/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.plantuml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithExternalFiles;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLCodeFenceLanguageProvider;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLCodeGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0015H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLCodeGeneratingProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownCodeFenceCacheableProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithExternalFiles;", "collector", "Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;", "(Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;)V", "description", "", "getDescription", "()Ljava/lang/String;", "displayName", "getDisplayName", "downloadFilename", "getDownloadFilename", "downloadLink", "getDownloadLink", "id", "getId", "cacheDiagram", "", "path", "Ljava/io/File;", "text", "generateDiagram", "", "diagramPath", "generateHtml", "language", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "isApplicable", "", "onLAFChanged", "storeDiagram", "source", "file", "Companion", "intellij.markdown"})
public final class PlantUMLCodeGeneratingProvider
extends MarkdownCodeFenceCacheableProvider
implements MarkdownExtensionWithExternalFiles {
    @NotNull
    private final String downloadLink;
    @NotNull
    private final String downloadFilename;
    @NotNull
    private final String displayName;
    @NotNull
    private final String description;
    @NotNull
    private final String id;
    private static final Logger LOG;
    private static final Lazy sourceStringReader$delegate;
    private static final Lazy generateImageMethod$delegate;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getDownloadLink() {
        return this.downloadLink;
    }

    @Override
    @NotNull
    public String getDownloadFilename() {
        return this.downloadFilename;
    }

    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.isEnabled() && this.isAvailable() && (Intrinsics.areEqual((Object)language, (Object)"puml") || Intrinsics.areEqual((Object)language, (Object)"plantuml"));
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        File key;
        block0: {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            File file = key = this.getUniqueFile(language, raw, "png").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"key");
            this.cacheDiagram(file, raw);
            MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector = this.getCollector();
            if (markdownCodeFencePluginCacheCollector == null) break block0;
            MarkdownCodeFencePluginCacheCollector.addAliveCachedFile$default(markdownCodeFencePluginCacheCollector, this, key, 0L, 4, null);
        }
        return "<img src=\"" + key.toURI() + "\"/>";
    }

    @Override
    public void onLAFChanged() {
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private final void cacheDiagram(File path, String text) {
        if (!path.exists()) {
            this.generateDiagram(text, path);
        }
    }

    private final void generateDiagram(CharSequence text, File diagramPath) throws IOException {
        String string = ((Object)text).toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String innerText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.startsWith$default((String)innerText, (String)"@startuml", (boolean)false, (int)2, null)) {
            innerText = "@startuml\n" + innerText;
        }
        if (!StringsKt.endsWith$default((String)innerText, (String)"@enduml", (boolean)false, (int)2, null)) {
            innerText = innerText + "\n@enduml";
        }
        FileUtil.createParentDirs((File)diagramPath);
        this.storeDiagram(innerText, diagramPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void storeDiagram(String source, File file) {
        try {
            Object object = file;
            int n = 0;
            object = new FileOutputStream((File)object);
            n = 8192;
            boolean bl = false;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            n = 0;
            bl = false;
            Throwable throwable = null;
            try {
                GenericDeclaration genericDeclaration;
                BufferedOutputStream it = (BufferedOutputStream)object;
                boolean bl2 = false;
                Method method = PlantUMLCodeGeneratingProvider.Companion.getGenerateImageMethod();
                Object object2 = method != null ? method.invoke((genericDeclaration = PlantUMLCodeGeneratingProvider.Companion.getSourceStringReader()) != null && (genericDeclaration = ((Class)genericDeclaration).getConstructor(String.class)) != null ? ((Constructor)genericDeclaration).newInstance(source) : null, it) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot save diagram PlantUML diagram. ", (Throwable)e);
        }
    }

    public PlantUMLCodeGeneratingProvider(@Nullable MarkdownCodeFencePluginCacheCollector collector) {
        super(collector);
        String string = Registry.stringValue((String)"markdown.plantuml.download.link");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Registry.stringValue(\"ma\u2026.plantuml.download.link\")");
        this.downloadLink = string;
        this.downloadFilename = "plantuml.jar";
        String string2 = MarkdownBundle.message("markdown.extensions.plantuml.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MarkdownBundle.message(\"\u2026s.plantuml.display.name\")");
        this.displayName = string2;
        String string3 = MarkdownBundle.message("markdown.extensions.plantuml.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MarkdownBundle.message(\"\u2026ns.plantuml.description\")");
        this.description = string3;
        this.id = "PlantUMLLanguageExtension";
    }

    public /* synthetic */ PlantUMLCodeGeneratingProvider(MarkdownCodeFencePluginCacheCollector markdownCodeFencePluginCacheCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            markdownCodeFencePluginCacheCollector = null;
        }
        this(markdownCodeFencePluginCacheCollector);
    }

    public PlantUMLCodeGeneratingProvider() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(PlantUMLCodeFenceLanguageProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Plant\u2026uageProvider::class.java)");
        LOG = logger;
        sourceStringReader$delegate = LazyKt.lazy((Function0)Companion.sourceStringReader.2.INSTANCE);
        generateImageMethod$delegate = LazyKt.lazy((Function0)Companion.generateImageMethod.2.INSTANCE);
    }

    @Override
    public boolean isAvailable() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.isAvailable(this);
    }

    @Override
    public boolean isEnabled() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.isEnabled(this);
    }

    @Override
    @NotNull
    public String getDirectoryName() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.getDirectoryName(this);
    }

    @Override
    @NotNull
    public File getDirectory() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.getDirectory(this);
    }

    @Override
    @NotNull
    public File getFullPath() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.getFullPath(this);
    }

    @Override
    public boolean afterDownload() {
        return MarkdownExtensionWithExternalFiles.DefaultImpls.afterDownload(this);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLCodeGeneratingProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "generateImageMethod", "Ljava/lang/reflect/Method;", "getGenerateImageMethod", "()Ljava/lang/reflect/Method;", "generateImageMethod$delegate", "Lkotlin/Lazy;", "sourceStringReader", "Ljava/lang/Class;", "getSourceStringReader", "()Ljava/lang/Class;", "sourceStringReader$delegate", "intellij.markdown"})
    public static final class Companion {
        private final Class<?> getSourceStringReader() {
            Lazy lazy = sourceStringReader$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Class)lazy.getValue();
        }

        private final Method getGenerateImageMethod() {
            Lazy lazy = generateImageMethod$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Method)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

