/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.UserFieldDataType;

class UserFieldCounters {
    private final Map<String, Integer> m_counters = new HashMap<String, Integer>();
    private final String[][] m_names = new String[UserFieldDataType.values().length][];

    public UserFieldCounters() {
        for (UserFieldDataType userFieldDataType : UserFieldDataType.values()) {
            this.m_names[userFieldDataType.ordinal()] = userFieldDataType.getDefaultFieldNames();
        }
    }

    public void setFieldNamesForType(UserFieldDataType userFieldDataType, String[] stringArray) {
        this.m_names[userFieldDataType.ordinal()] = stringArray;
    }

    public <E extends Enum<E>> E nextField(Class<E> clazz, UserFieldDataType userFieldDataType) {
        for (String string : this.m_names[userFieldDataType.ordinal()]) {
            int n = NumberHelper.getInt(this.m_counters.get(string)) + 1;
            try {
                E e = Enum.valueOf(clazz, string + n);
                this.m_counters.put(string, n);
                return e;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("No fields for type " + (Object)((Object)userFieldDataType) + " available");
    }

    public void reset() {
        this.m_counters.clear();
    }
}

