/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiString")
public class AIString
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int DATA;

    public AIString(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIString.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ai_uint32")
    public int length() {
        return AIString.nlength(this.address());
    }

    @NativeType(value="char[Assimp.MAXLEN]")
    public ByteBuffer data() {
        return AIString.ndata(this.address());
    }

    @NativeType(value="char[Assimp.MAXLEN]")
    public String dataString() {
        return AIString.ndataString(this.address());
    }

    public AIString data(@NativeType(value="char[Assimp.MAXLEN]") ByteBuffer value) {
        AIString.ndata(this.address(), value);
        return this;
    }

    public AIString set(AIString src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIString malloc() {
        return (AIString)AIString.wrap(AIString.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIString calloc() {
        return (AIString)AIString.wrap(AIString.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIString create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIString)AIString.wrap(AIString.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIString create(long address) {
        return (AIString)AIString.wrap(AIString.class, (long)address);
    }

    @Nullable
    public static AIString createSafe(long address) {
        return address == 0L ? null : (AIString)AIString.wrap(AIString.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIString.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIString.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIString.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIString.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIString.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIString.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIString.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIString mallocStack() {
        return AIString.mallocStack(MemoryStack.stackGet());
    }

    public static AIString callocStack() {
        return AIString.callocStack(MemoryStack.stackGet());
    }

    public static AIString mallocStack(MemoryStack stack) {
        return (AIString)AIString.wrap(AIString.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIString callocStack(MemoryStack stack) {
        return (AIString)AIString.wrap(AIString.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIString.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIString.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIString.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIString.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nlength(long struct) {
        return UNSAFE.getInt(null, struct + (long)LENGTH);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DATA), (int)AIString.nlength(struct));
    }

    public static String ndataString(long struct) {
        return MemoryUtil.memUTF8((ByteBuffer)AIString.ndata(struct));
    }

    public static void nlength(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LENGTH, value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)1024);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DATA), (long)value.remaining());
        AIString.nlength(struct, value.remaining() - 1);
    }

    static {
        Struct.Layout layout = AIString.__struct((Struct.Member[])new Struct.Member[]{AIString.__member((int)4), AIString.__array((int)1, (int)1024)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIString, Buffer>
    implements NativeResource {
        private static final AIString ELEMENT_FACTORY = AIString.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIString getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ai_uint32")
        public int length() {
            return AIString.nlength(this.address());
        }

        @NativeType(value="char[Assimp.MAXLEN]")
        public ByteBuffer data() {
            return AIString.ndata(this.address());
        }

        @NativeType(value="char[Assimp.MAXLEN]")
        public String dataString() {
            return AIString.ndataString(this.address());
        }

        public Buffer data(@NativeType(value="char[Assimp.MAXLEN]") ByteBuffer value) {
            AIString.ndata(this.address(), value);
            return this;
        }
    }
}

