/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkPluginAlloc;
import org.lwjgl.nuklear.NkPluginAllocI;
import org.lwjgl.nuklear.NkPluginFree;
import org.lwjgl.nuklear.NkPluginFreeI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_allocator")
public class NkAllocator
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int USERDATA;
    public static final int ALLOC;
    public static final int MFREE;

    public NkAllocator(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkAllocator.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkAllocator.nuserdata(this.address());
    }

    @Nullable
    @NativeType(value="nk_plugin_alloc")
    public NkPluginAlloc alloc() {
        return NkAllocator.nalloc(this.address());
    }

    @Nullable
    @NativeType(value="nk_plugin_free")
    public NkPluginFree mfree() {
        return NkAllocator.nmfree(this.address());
    }

    public NkAllocator userdata(@NativeType(value="nk_handle") NkHandle value) {
        NkAllocator.nuserdata(this.address(), value);
        return this;
    }

    public NkAllocator userdata(Consumer<NkHandle> consumer) {
        consumer.accept(this.userdata());
        return this;
    }

    public NkAllocator alloc(@Nullable @NativeType(value="nk_plugin_alloc") NkPluginAllocI value) {
        NkAllocator.nalloc(this.address(), value);
        return this;
    }

    public NkAllocator mfree(@Nullable @NativeType(value="nk_plugin_free") NkPluginFreeI value) {
        NkAllocator.nmfree(this.address(), value);
        return this;
    }

    public NkAllocator set(NkHandle userdata, NkPluginAllocI alloc, NkPluginFreeI mfree) {
        this.userdata(userdata);
        this.alloc(alloc);
        this.mfree(mfree);
        return this;
    }

    public NkAllocator set(NkAllocator src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkAllocator malloc() {
        return (NkAllocator)NkAllocator.wrap(NkAllocator.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkAllocator calloc() {
        return (NkAllocator)NkAllocator.wrap(NkAllocator.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkAllocator create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkAllocator)NkAllocator.wrap(NkAllocator.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkAllocator create(long address) {
        return (NkAllocator)NkAllocator.wrap(NkAllocator.class, (long)address);
    }

    @Nullable
    public static NkAllocator createSafe(long address) {
        return address == 0L ? null : (NkAllocator)NkAllocator.wrap(NkAllocator.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkAllocator.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkAllocator.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkAllocator.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkAllocator.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkAllocator.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkAllocator.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkAllocator.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkAllocator mallocStack() {
        return NkAllocator.mallocStack(MemoryStack.stackGet());
    }

    public static NkAllocator callocStack() {
        return NkAllocator.callocStack(MemoryStack.stackGet());
    }

    public static NkAllocator mallocStack(MemoryStack stack) {
        return (NkAllocator)NkAllocator.wrap(NkAllocator.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkAllocator callocStack(MemoryStack stack) {
        return (NkAllocator)NkAllocator.wrap(NkAllocator.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkAllocator.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkAllocator.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkAllocator.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkAllocator.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    @Nullable
    public static NkPluginAlloc nalloc(long struct) {
        return NkPluginAlloc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ALLOC)));
    }

    @Nullable
    public static NkPluginFree nmfree(long struct) {
        return NkPluginFree.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MFREE)));
    }

    public static void nuserdata(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USERDATA), (long)NkHandle.SIZEOF);
    }

    public static void nalloc(long struct, @Nullable NkPluginAllocI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ALLOC), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmfree(long struct, @Nullable NkPluginFreeI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MFREE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkAllocator.__struct((Struct.Member[])new Struct.Member[]{NkAllocator.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkAllocator.__member((int)POINTER_SIZE), NkAllocator.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        USERDATA = layout.offsetof(0);
        ALLOC = layout.offsetof(1);
        MFREE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkAllocator, Buffer>
    implements NativeResource {
        private static final NkAllocator ELEMENT_FACTORY = NkAllocator.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkAllocator getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkAllocator.nuserdata(this.address());
        }

        @Nullable
        @NativeType(value="nk_plugin_alloc")
        public NkPluginAlloc alloc() {
            return NkAllocator.nalloc(this.address());
        }

        @Nullable
        @NativeType(value="nk_plugin_free")
        public NkPluginFree mfree() {
            return NkAllocator.nmfree(this.address());
        }

        public Buffer userdata(@NativeType(value="nk_handle") NkHandle value) {
            NkAllocator.nuserdata(this.address(), value);
            return this;
        }

        public Buffer userdata(Consumer<NkHandle> consumer) {
            consumer.accept(this.userdata());
            return this;
        }

        public Buffer alloc(@Nullable @NativeType(value="nk_plugin_alloc") NkPluginAllocI value) {
            NkAllocator.nalloc(this.address(), value);
            return this;
        }

        public Buffer mfree(@Nullable @NativeType(value="nk_plugin_free") NkPluginFreeI value) {
            NkAllocator.nmfree(this.address(), value);
            return this;
        }
    }
}

