/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMOptRemarkArg;
import org.lwjgl.llvm.LLVMOptRemarkDebugLoc;
import org.lwjgl.llvm.LLVMOptRemarkStringRef;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOptRemarkEntry
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REMARKTYPE;
    public static final int PASSNAME;
    public static final int REMARKNAME;
    public static final int FUNCTIONNAME;
    public static final int DEBUGLOC;
    public static final int HOTNESS;
    public static final int NUMARGS;
    public static final int ARGS;

    public LLVMOptRemarkEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOptRemarkEntry.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public LLVMOptRemarkStringRef RemarkType() {
        return LLVMOptRemarkEntry.nRemarkType(this.address());
    }

    public LLVMOptRemarkStringRef PassName() {
        return LLVMOptRemarkEntry.nPassName(this.address());
    }

    public LLVMOptRemarkStringRef RemarkName() {
        return LLVMOptRemarkEntry.nRemarkName(this.address());
    }

    public LLVMOptRemarkStringRef FunctionName() {
        return LLVMOptRemarkEntry.nFunctionName(this.address());
    }

    public LLVMOptRemarkDebugLoc DebugLoc() {
        return LLVMOptRemarkEntry.nDebugLoc(this.address());
    }

    @NativeType(value="uint32_t")
    public int Hotness() {
        return LLVMOptRemarkEntry.nHotness(this.address());
    }

    @NativeType(value="uint32_t")
    public int NumArgs() {
        return LLVMOptRemarkEntry.nNumArgs(this.address());
    }

    @NativeType(value="LLVMOptRemarkArg *")
    public LLVMOptRemarkArg.Buffer Args() {
        return LLVMOptRemarkEntry.nArgs(this.address());
    }

    public static LLVMOptRemarkEntry create(long address) {
        return (LLVMOptRemarkEntry)LLVMOptRemarkEntry.wrap(LLVMOptRemarkEntry.class, (long)address);
    }

    @Nullable
    public static LLVMOptRemarkEntry createSafe(long address) {
        return address == 0L ? null : (LLVMOptRemarkEntry)LLVMOptRemarkEntry.wrap(LLVMOptRemarkEntry.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)LLVMOptRemarkEntry.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)LLVMOptRemarkEntry.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static LLVMOptRemarkStringRef nRemarkType(long struct) {
        return LLVMOptRemarkStringRef.create(struct + (long)REMARKTYPE);
    }

    public static LLVMOptRemarkStringRef nPassName(long struct) {
        return LLVMOptRemarkStringRef.create(struct + (long)PASSNAME);
    }

    public static LLVMOptRemarkStringRef nRemarkName(long struct) {
        return LLVMOptRemarkStringRef.create(struct + (long)REMARKNAME);
    }

    public static LLVMOptRemarkStringRef nFunctionName(long struct) {
        return LLVMOptRemarkStringRef.create(struct + (long)FUNCTIONNAME);
    }

    public static LLVMOptRemarkDebugLoc nDebugLoc(long struct) {
        return LLVMOptRemarkDebugLoc.create(struct + (long)DEBUGLOC);
    }

    public static int nHotness(long struct) {
        return UNSAFE.getInt(null, struct + (long)HOTNESS);
    }

    public static int nNumArgs(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUMARGS);
    }

    public static LLVMOptRemarkArg.Buffer nArgs(long struct) {
        return LLVMOptRemarkArg.create(MemoryUtil.memGetAddress((long)(struct + (long)ARGS)), LLVMOptRemarkEntry.nNumArgs(struct));
    }

    static {
        Struct.Layout layout = LLVMOptRemarkEntry.__struct((Struct.Member[])new Struct.Member[]{LLVMOptRemarkEntry.__member((int)LLVMOptRemarkStringRef.SIZEOF, (int)LLVMOptRemarkStringRef.ALIGNOF), LLVMOptRemarkEntry.__member((int)LLVMOptRemarkStringRef.SIZEOF, (int)LLVMOptRemarkStringRef.ALIGNOF), LLVMOptRemarkEntry.__member((int)LLVMOptRemarkStringRef.SIZEOF, (int)LLVMOptRemarkStringRef.ALIGNOF), LLVMOptRemarkEntry.__member((int)LLVMOptRemarkStringRef.SIZEOF, (int)LLVMOptRemarkStringRef.ALIGNOF), LLVMOptRemarkEntry.__member((int)LLVMOptRemarkDebugLoc.SIZEOF, (int)LLVMOptRemarkDebugLoc.ALIGNOF), LLVMOptRemarkEntry.__member((int)4), LLVMOptRemarkEntry.__member((int)4), LLVMOptRemarkEntry.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REMARKTYPE = layout.offsetof(0);
        PASSNAME = layout.offsetof(1);
        REMARKNAME = layout.offsetof(2);
        FUNCTIONNAME = layout.offsetof(3);
        DEBUGLOC = layout.offsetof(4);
        HOTNESS = layout.offsetof(5);
        NUMARGS = layout.offsetof(6);
        ARGS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<LLVMOptRemarkEntry, Buffer> {
        private static final LLVMOptRemarkEntry ELEMENT_FACTORY = LLVMOptRemarkEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOptRemarkEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public LLVMOptRemarkStringRef RemarkType() {
            return LLVMOptRemarkEntry.nRemarkType(this.address());
        }

        public LLVMOptRemarkStringRef PassName() {
            return LLVMOptRemarkEntry.nPassName(this.address());
        }

        public LLVMOptRemarkStringRef RemarkName() {
            return LLVMOptRemarkEntry.nRemarkName(this.address());
        }

        public LLVMOptRemarkStringRef FunctionName() {
            return LLVMOptRemarkEntry.nFunctionName(this.address());
        }

        public LLVMOptRemarkDebugLoc DebugLoc() {
            return LLVMOptRemarkEntry.nDebugLoc(this.address());
        }

        @NativeType(value="uint32_t")
        public int Hotness() {
            return LLVMOptRemarkEntry.nHotness(this.address());
        }

        @NativeType(value="uint32_t")
        public int NumArgs() {
            return LLVMOptRemarkEntry.nNumArgs(this.address());
        }

        @NativeType(value="LLVMOptRemarkArg *")
        public LLVMOptRemarkArg.Buffer Args() {
            return LLVMOptRemarkEntry.nArgs(this.address());
        }
    }
}

