/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_memory_t")
public class BGFXMemory
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;

    public BGFXMemory(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXMemory.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXMemory.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXMemory.nsize(this.address());
    }

    public BGFXMemory data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXMemory.ndata(this.address(), value);
        return this;
    }

    public BGFXMemory set(BGFXMemory src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXMemory malloc() {
        return (BGFXMemory)BGFXMemory.wrap(BGFXMemory.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static BGFXMemory calloc() {
        return (BGFXMemory)BGFXMemory.wrap(BGFXMemory.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static BGFXMemory create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (BGFXMemory)BGFXMemory.wrap(BGFXMemory.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static BGFXMemory create(long address) {
        return (BGFXMemory)BGFXMemory.wrap(BGFXMemory.class, (long)address);
    }

    @Nullable
    public static BGFXMemory createSafe(long address) {
        return address == 0L ? null : (BGFXMemory)BGFXMemory.wrap(BGFXMemory.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)BGFXMemory.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)BGFXMemory.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)BGFXMemory.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXMemory.__create((int)capacity, (int)SIZEOF);
        return (Buffer)BGFXMemory.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)BGFXMemory.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)BGFXMemory.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static BGFXMemory mallocStack() {
        return BGFXMemory.mallocStack(MemoryStack.stackGet());
    }

    public static BGFXMemory callocStack() {
        return BGFXMemory.callocStack(MemoryStack.stackGet());
    }

    public static BGFXMemory mallocStack(MemoryStack stack) {
        return (BGFXMemory)BGFXMemory.wrap(BGFXMemory.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXMemory callocStack(MemoryStack stack) {
        return (BGFXMemory)BGFXMemory.wrap(BGFXMemory.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return BGFXMemory.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return BGFXMemory.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)BGFXMemory.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)BGFXMemory.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)BGFXMemory.nsize(struct));
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        BGFXMemory.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            BGFXMemory.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = BGFXMemory.__struct((Struct.Member[])new Struct.Member[]{BGFXMemory.__member((int)POINTER_SIZE), BGFXMemory.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXMemory, Buffer>
    implements NativeResource {
        private static final BGFXMemory ELEMENT_FACTORY = BGFXMemory.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXMemory getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXMemory.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXMemory.nsize(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXMemory.ndata(this.address(), value);
            return this;
        }
    }
}

