/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkSubpassBeginInfo;

public class VkSubpassBeginInfoKHR
extends VkSubpassBeginInfo {
    public VkSubpassBeginInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkSubpassBeginInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassBeginInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassBeginInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassBeginInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassBeginInfoKHR contents(@NativeType(value="VkSubpassContents") int value) {
        VkSubpassBeginInfoKHR.ncontents(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassBeginInfoKHR set(int sType, long pNext, int contents) {
        this.sType(sType);
        this.pNext(pNext);
        this.contents(contents);
        return this;
    }

    public VkSubpassBeginInfoKHR set(VkSubpassBeginInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassBeginInfoKHR malloc() {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubpassBeginInfoKHR calloc() {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubpassBeginInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubpassBeginInfoKHR create(long address) {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkSubpassBeginInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubpassBeginInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassBeginInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSubpassBeginInfoKHR mallocStack() {
        return VkSubpassBeginInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfoKHR callocStack() {
        return VkSubpassBeginInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfoKHR mallocStack(MemoryStack stack) {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassBeginInfoKHR callocStack(MemoryStack stack) {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassBeginInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassBeginInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkSubpassBeginInfo.Buffer {
        private static final VkSubpassBeginInfoKHR ELEMENT_FACTORY = VkSubpassBeginInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubpassBeginInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassBeginInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassBeginInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer contents(@NativeType(value="VkSubpassContents") int value) {
            VkSubpassBeginInfoKHR.ncontents(this.address(), value);
            return this;
        }
    }
}

