/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferDeviceAddressInfo;

public class VkBufferDeviceAddressInfoEXT
extends VkBufferDeviceAddressInfo {
    public VkBufferDeviceAddressInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferDeviceAddressInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkBufferDeviceAddressInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkBufferDeviceAddressInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoEXT buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferDeviceAddressInfoEXT.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBufferDeviceAddressInfoEXT set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferDeviceAddressInfoEXT set(VkBufferDeviceAddressInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferDeviceAddressInfoEXT malloc() {
        return (VkBufferDeviceAddressInfoEXT)VkBufferDeviceAddressInfoEXT.wrap(VkBufferDeviceAddressInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferDeviceAddressInfoEXT calloc() {
        return (VkBufferDeviceAddressInfoEXT)VkBufferDeviceAddressInfoEXT.wrap(VkBufferDeviceAddressInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferDeviceAddressInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferDeviceAddressInfoEXT)VkBufferDeviceAddressInfoEXT.wrap(VkBufferDeviceAddressInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferDeviceAddressInfoEXT create(long address) {
        return (VkBufferDeviceAddressInfoEXT)VkBufferDeviceAddressInfoEXT.wrap(VkBufferDeviceAddressInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkBufferDeviceAddressInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkBufferDeviceAddressInfoEXT)VkBufferDeviceAddressInfoEXT.wrap(VkBufferDeviceAddressInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferDeviceAddressInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferDeviceAddressInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferDeviceAddressInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferDeviceAddressInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferDeviceAddressInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferDeviceAddressInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBufferDeviceAddressInfoEXT mallocStack() {
        return VkBufferDeviceAddressInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkBufferDeviceAddressInfoEXT callocStack() {
        return VkBufferDeviceAddressInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkBufferDeviceAddressInfoEXT mallocStack(MemoryStack stack) {
        return (VkBufferDeviceAddressInfoEXT)VkBufferDeviceAddressInfoEXT.wrap(VkBufferDeviceAddressInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferDeviceAddressInfoEXT callocStack(MemoryStack stack) {
        return (VkBufferDeviceAddressInfoEXT)VkBufferDeviceAddressInfoEXT.wrap(VkBufferDeviceAddressInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBufferDeviceAddressInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBufferDeviceAddressInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferDeviceAddressInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkBufferDeviceAddressInfo.Buffer {
        private static final VkBufferDeviceAddressInfoEXT ELEMENT_FACTORY = VkBufferDeviceAddressInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferDeviceAddressInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferDeviceAddressInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferDeviceAddressInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferDeviceAddressInfoEXT.nbuffer(this.address(), value);
            return this;
        }
    }
}

