/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.rpmalloc.RPMemoryMapCallback;
import org.lwjgl.system.rpmalloc.RPMemoryMapCallbackI;
import org.lwjgl.system.rpmalloc.RPMemoryUnmapCallback;
import org.lwjgl.system.rpmalloc.RPMemoryUnmapCallbackI;

@NativeType(value="struct rpmalloc_config_t")
public class RPMallocConfig
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORY_MAP;
    public static final int MEMORY_UNMAP;
    public static final int PAGE_SIZE;
    public static final int SPAN_SIZE;
    public static final int SPAN_MAP_COUNT;
    public static final int ENABLE_HUGE_PAGES;

    public RPMallocConfig(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RPMallocConfig.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="void * (*) (size_t, size_t *)")
    public RPMemoryMapCallback memory_map() {
        return RPMallocConfig.nmemory_map(this.address());
    }

    @Nullable
    @NativeType(value="void (*) (void *, size_t, size_t, int)")
    public RPMemoryUnmapCallback memory_unmap() {
        return RPMallocConfig.nmemory_unmap(this.address());
    }

    @NativeType(value="size_t")
    public long page_size() {
        return RPMallocConfig.npage_size(this.address());
    }

    @NativeType(value="size_t")
    public long span_size() {
        return RPMallocConfig.nspan_size(this.address());
    }

    @NativeType(value="size_t")
    public long span_map_count() {
        return RPMallocConfig.nspan_map_count(this.address());
    }

    @NativeType(value="int")
    public boolean enable_huge_pages() {
        return RPMallocConfig.nenable_huge_pages(this.address()) != 0;
    }

    public RPMallocConfig memory_map(@Nullable @NativeType(value="void * (*) (size_t, size_t *)") RPMemoryMapCallbackI value) {
        RPMallocConfig.nmemory_map(this.address(), value);
        return this;
    }

    public RPMallocConfig memory_unmap(@Nullable @NativeType(value="void (*) (void *, size_t, size_t, int)") RPMemoryUnmapCallbackI value) {
        RPMallocConfig.nmemory_unmap(this.address(), value);
        return this;
    }

    public RPMallocConfig page_size(@NativeType(value="size_t") long value) {
        RPMallocConfig.npage_size(this.address(), value);
        return this;
    }

    public RPMallocConfig span_size(@NativeType(value="size_t") long value) {
        RPMallocConfig.nspan_size(this.address(), value);
        return this;
    }

    public RPMallocConfig span_map_count(@NativeType(value="size_t") long value) {
        RPMallocConfig.nspan_map_count(this.address(), value);
        return this;
    }

    public RPMallocConfig enable_huge_pages(@NativeType(value="int") boolean value) {
        RPMallocConfig.nenable_huge_pages(this.address(), value ? 1 : 0);
        return this;
    }

    public RPMallocConfig set(RPMemoryMapCallbackI memory_map, RPMemoryUnmapCallbackI memory_unmap, long page_size, long span_size, long span_map_count, boolean enable_huge_pages) {
        this.memory_map(memory_map);
        this.memory_unmap(memory_unmap);
        this.page_size(page_size);
        this.span_size(span_size);
        this.span_map_count(span_map_count);
        this.enable_huge_pages(enable_huge_pages);
        return this;
    }

    public RPMallocConfig set(RPMallocConfig src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static RPMallocConfig malloc() {
        return (RPMallocConfig)RPMallocConfig.wrap(RPMallocConfig.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static RPMallocConfig calloc() {
        return (RPMallocConfig)RPMallocConfig.wrap(RPMallocConfig.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static RPMallocConfig create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (RPMallocConfig)RPMallocConfig.wrap(RPMallocConfig.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static RPMallocConfig create(long address) {
        return (RPMallocConfig)RPMallocConfig.wrap(RPMallocConfig.class, (long)address);
    }

    @Nullable
    public static RPMallocConfig createSafe(long address) {
        return address == 0L ? null : (RPMallocConfig)RPMallocConfig.wrap(RPMallocConfig.class, (long)address);
    }

    public static RPMallocConfig mallocStack() {
        return RPMallocConfig.mallocStack(MemoryStack.stackGet());
    }

    public static RPMallocConfig callocStack() {
        return RPMallocConfig.callocStack(MemoryStack.stackGet());
    }

    public static RPMallocConfig mallocStack(MemoryStack stack) {
        return (RPMallocConfig)RPMallocConfig.wrap(RPMallocConfig.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RPMallocConfig callocStack(MemoryStack stack) {
        return (RPMallocConfig)RPMallocConfig.wrap(RPMallocConfig.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    @Nullable
    public static RPMemoryMapCallback nmemory_map(long struct) {
        return RPMemoryMapCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MEMORY_MAP)));
    }

    @Nullable
    public static RPMemoryUnmapCallback nmemory_unmap(long struct) {
        return RPMemoryUnmapCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MEMORY_UNMAP)));
    }

    public static long npage_size(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PAGE_SIZE));
    }

    public static long nspan_size(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPAN_SIZE));
    }

    public static long nspan_map_count(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPAN_MAP_COUNT));
    }

    public static int nenable_huge_pages(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLE_HUGE_PAGES);
    }

    public static void nmemory_map(long struct, @Nullable RPMemoryMapCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEMORY_MAP), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmemory_unmap(long struct, @Nullable RPMemoryUnmapCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEMORY_UNMAP), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npage_size(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PAGE_SIZE), (long)value);
    }

    public static void nspan_size(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPAN_SIZE), (long)value);
    }

    public static void nspan_map_count(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPAN_MAP_COUNT), (long)value);
    }

    public static void nenable_huge_pages(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLE_HUGE_PAGES, value);
    }

    static {
        Struct.Layout layout = RPMallocConfig.__struct((Struct.Member[])new Struct.Member[]{RPMallocConfig.__member((int)POINTER_SIZE), RPMallocConfig.__member((int)POINTER_SIZE), RPMallocConfig.__member((int)POINTER_SIZE), RPMallocConfig.__member((int)POINTER_SIZE), RPMallocConfig.__member((int)POINTER_SIZE), RPMallocConfig.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORY_MAP = layout.offsetof(0);
        MEMORY_UNMAP = layout.offsetof(1);
        PAGE_SIZE = layout.offsetof(2);
        SPAN_SIZE = layout.offsetof(3);
        SPAN_MAP_COUNT = layout.offsetof(4);
        ENABLE_HUGE_PAGES = layout.offsetof(5);
    }
}

