/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.CompilationUnit;

public final class JavaInput
extends Input {
    private static final Splitter NEWLINE_SPLITTER = Splitter.on((char)'\n');
    private final String text;
    private int kN;
    private Map<Integer, Range<Integer>> kToI = null;
    private final ImmutableMap<Integer, Integer> positionToColumnMap;
    private final ImmutableList<Token> tokens;
    private final ImmutableRangeMap<Integer, Token> positionTokenMap;
    private final Token[] kToToken;
    private CompilationUnit unit;

    public JavaInput(String text) throws FormatterException {
        this.text = (String)Preconditions.checkNotNull((Object)text);
        List lines = NEWLINE_SPLITTER.splitToList((CharSequence)text);
        this.setLines((ImmutableList<String>)ImmutableList.copyOf((Collection)lines));
        ImmutableList<Tok> toks = this.buildToks(text);
        this.positionToColumnMap = JavaInput.makePositionToColumnMap(toks);
        this.tokens = JavaInput.buildTokens(toks);
        ImmutableRangeMap.Builder tokenLocations = ImmutableRangeMap.builder();
        for (Token token : this.tokens) {
            Input.Tok end = JavaOutput.endTok(token);
            int upper = end.getPosition();
            if (!end.getText().isEmpty()) {
                upper += end.length() - 1;
            }
            tokenLocations.put(Range.closed((Comparable)Integer.valueOf(JavaOutput.startTok(token).getPosition()), (Comparable)Integer.valueOf(upper)), (Object)token);
        }
        this.positionTokenMap = tokenLocations.build();
        this.kToToken = new Token[this.kN + 1];
        for (Token token : this.tokens) {
            for (Input.Tok tok : token.getToksBefore()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
            this.kToToken[token.getTok().getIndex()] = token;
            for (Input.Tok tok : token.getToksAfter()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
        }
    }

    private static ImmutableMap<Integer, Integer> makePositionToColumnMap(List<Tok> toks) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Tok tok : toks) {
            builder.put((Object)tok.getPosition(), (Object)tok.getColumn());
        }
        return builder.build();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ImmutableMap<Integer, Integer> getPositionToColumnMap() {
        return this.positionToColumnMap;
    }

    private ImmutableList<Tok> buildToks(String text) throws FormatterException {
        try {
            ImmutableList<Tok> toks = JavaInput.buildToks(text, (ImmutableSet<Integer>)ImmutableSet.of());
            this.kN = ((Tok)Iterables.getLast(toks)).getIndex();
            this.computeRanges((List<? extends Input.Tok>)toks);
            return toks;
        }
        catch (InvalidInputException e) {
            return ImmutableList.of();
        }
    }

    static ImmutableList<Tok> buildToks(String text, ImmutableSet<Integer> stopIds) throws InvalidInputException, FormatterException {
        int tokenId;
        stopIds = ImmutableSet.builder().addAll(stopIds).add((Object)158).build();
        int kN = 0;
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)true, (boolean)true, (String)"1.8");
        scanner.setSource(text.toCharArray());
        int textLength = text.length();
        ArrayList<Tok> toks = new ArrayList<Tok>();
        int charI = 0;
        int columnI = 0;
        while (scanner.getCurrentTokenEndPosition() < textLength - 1 && !stopIds.contains((Object)(tokenId = scanner.getNextToken()))) {
            boolean isNumbered;
            boolean isToken;
            int charI0 = scanner.getCurrentTokenStartPosition();
            String originalTokText = text.substring(charI0, scanner.getCurrentTokenEndPosition() + 1);
            String tokText = new String(scanner.getCurrentTokenSource());
            char tokText0 = tokText.charAt(0);
            boolean extraNewline = false;
            ArrayList<String> strings = new ArrayList<String>();
            if (Character.isWhitespace(tokText0)) {
                isToken = false;
                isNumbered = false;
                boolean first = true;
                for (String spaces : NEWLINE_SPLITTER.split((CharSequence)originalTokText)) {
                    if (!first) {
                        strings.add("\n");
                    }
                    if (!spaces.isEmpty()) {
                        strings.add(spaces);
                    }
                    first = false;
                }
            } else if (tokText.startsWith("'") || tokText.startsWith("\"")) {
                isToken = true;
                isNumbered = true;
                strings.add(originalTokText);
            } else if (tokText.startsWith("//") || tokText.startsWith("/*")) {
                if (tokText.startsWith("//") && originalTokText.endsWith("\n")) {
                    originalTokText = originalTokText.substring(0, originalTokText.length() - 1);
                    tokText = tokText.substring(0, tokText.length() - 1);
                    extraNewline = true;
                }
                isToken = false;
                isNumbered = true;
                strings.add(originalTokText);
            } else if (Character.isJavaIdentifierStart(tokText0) || Character.isDigit(tokText0) || tokText0 == '.' && tokText.length() > 1 && Character.isDigit(tokText.charAt(1))) {
                isToken = true;
                isNumbered = true;
                strings.add(tokText);
            } else {
                isToken = true;
                isNumbered = true;
                for (Object c : (Object)tokText.toCharArray()) {
                    strings.add(String.valueOf((char)c));
                }
            }
            if (strings.size() == 1) {
                toks.add(new Tok(isNumbered ? kN++ : -1, originalTokText, tokText, charI, columnI, isToken, tokenId));
                for (Object c : (Object)originalTokText.toCharArray()) {
                    columnI = c == 10 ? 0 : ++columnI;
                    ++charI;
                }
            } else {
                if (strings.size() != 1 && !tokText.equals(originalTokText)) {
                    throw new FormatterException("Unicode escapes not allowed in whitespace or multi-character operators");
                }
                for (String str : strings) {
                    toks.add(new Tok(isNumbered ? kN++ : -1, str, str, charI, columnI, isToken, tokenId));
                    for (char c : str.toCharArray()) {
                        columnI = c == '\n' ? 0 : ++columnI;
                        ++charI;
                    }
                }
            }
            if (!extraNewline) continue;
            toks.add(new Tok(-1, "\n", "\n", charI, columnI, false, tokenId));
            columnI = 0;
            ++charI;
        }
        toks.add(new Tok(kN, "", "", charI, columnI, true, 158));
        return ImmutableList.copyOf(toks);
    }

    /*
     * Unable to fully structure code
     */
    private static ImmutableList<Token> buildTokens(List<Tok> toks) {
        tokens = ImmutableList.builder();
        k = 0;
        kN = toks.size();
        while (k < kN) {
            toksBefore = ImmutableList.builder();
            while (!toks.get(k).isToken()) {
                toksBefore.add((Object)toks.get(k++));
            }
            tok = toks.get(k++);
            toksAfter = ImmutableList.builder();
            block16: while (k < kN && !toks.get(k).isToken()) {
                if (!toks.get(k).isSlashStarComment()) ** GOTO lbl-1000
                var7_7 = tok.getText();
                var8_8 = -1;
                switch (var7_7.hashCode()) {
                    case 40: {
                        if (!var7_7.equals("(")) break;
                        var8_8 = 0;
                        break;
                    }
                    case 60: {
                        if (!var7_7.equals("<")) break;
                        var8_8 = 1;
                        break;
                    }
                    case 46: {
                        if (!var7_7.equals(".")) break;
                        var8_8 = 2;
                    }
                }
                switch (var8_8) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break block16;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (toks.get(k).isJavadocComment()) {
                            var7_7 = tok.getText();
                            var8_8 = -1;
                            switch (var7_7.hashCode()) {
                                case 59: {
                                    if (!var7_7.equals(";")) break;
                                    var8_8 = 0;
                                }
                            }
                            switch (var8_8) {
                                case 0: {
                                    break block16;
                                }
                            }
                        }
                        nonTokenAfter = toks.get(k++);
                        toksAfter.add((Object)nonTokenAfter);
                        if (!nonTokenAfter.getText().contains("\n")) continue block16;
                        break block16;
                    }
                }
            }
            tokens.add((Object)new Token((List<Tok>)toksBefore.build(), tok, (List<Tok>)toksAfter.build()));
        }
        return tokens.build();
    }

    int getLineNumberLo(Token token) {
        Tok tok;
        int k = -1;
        UnmodifiableIterator unmodifiableIterator = token.toksBefore.iterator();
        while (unmodifiableIterator.hasNext() && (k = (tok = (Tok)unmodifiableIterator.next()).getIndex()) < 0) {
        }
        if (k < 0) {
            k = token.tok.getIndex();
        }
        if (this.kToI == null) {
            this.kToI = JavaInput.makeKToIJ(this, this.kN);
        }
        return (Integer)this.kToI.get(k).lowerEndpoint();
    }

    int getLineNumberHi(Token token) {
        Tok tok;
        int k = -1;
        UnmodifiableIterator unmodifiableIterator = token.toksAfter.reverse().iterator();
        while (unmodifiableIterator.hasNext() && (k = (tok = (Tok)unmodifiableIterator.next()).getIndex()) < 0) {
        }
        if (k < 0) {
            k = token.tok.getIndex();
        }
        if (this.kToI == null) {
            this.kToI = JavaInput.makeKToIJ(this, this.kN);
        }
        return (Integer)this.kToI.get(k).upperEndpoint() - 1;
    }

    Range<Integer> characterRangeToTokenRange(int offset, int length) throws FormatterException {
        ImmutableCollection enclosed;
        int requiredLength = offset + length;
        if (requiredLength > this.text.length()) {
            throw new FormatterException(String.format("error: invalid length %d, offset + length (%d) is outside the file", length, requiredLength));
        }
        if (length < 0) {
            return EMPTY_RANGE;
        }
        if (length == 0) {
            length = 1;
        }
        if ((enclosed = this.getPositionTokenMap().subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + length))).asMapOfRanges().values()).isEmpty()) {
            return EMPTY_RANGE;
        }
        return Range.closedOpen((Comparable)Integer.valueOf(((Token)enclosed.iterator().next()).getTok().getIndex()), (Comparable)Integer.valueOf(((Token)Iterables.getLast((Iterable)enclosed)).getTok().getIndex() + 1));
    }

    int getkN() {
        return this.kN;
    }

    Token getToken(int k) {
        return this.kToToken[k];
    }

    @Override
    public ImmutableList<? extends Input.Token> getTokens() {
        return this.tokens;
    }

    public ImmutableRangeMap<Integer, Token> getPositionTokenMap() {
        return this.positionTokenMap;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tokens", this.tokens).add("super", (Object)super.toString()).toString();
    }

    @Override
    public int getLineNumber(int inputPosition) {
        Verify.verifyNotNull((Object)this.unit, (String)"Expected compilation unit to be set.", (Object[])new Object[0]);
        return this.unit.getLineNumber(inputPosition);
    }

    @Override
    public int getColumnNumber(int inputPosition) {
        Verify.verifyNotNull((Object)this.unit, (String)"Expected compilation unit to be set.", (Object[])new Object[0]);
        return this.unit.getColumnNumber(inputPosition);
    }

    public void setCompilationUnit(CompilationUnit unit) {
        this.unit = unit;
    }

    public RangeSet<Integer> characterRangesToTokenRanges(Collection<Range<Integer>> characterRanges) throws FormatterException {
        TreeRangeSet tokenRangeSet = TreeRangeSet.create();
        for (Range<Integer> characterRange0 : characterRanges) {
            Range characterRange = characterRange0.canonical(DiscreteDomain.integers());
            tokenRangeSet.add(this.characterRangeToTokenRange((Integer)characterRange.lowerEndpoint(), (Integer)characterRange.upperEndpoint() - (Integer)characterRange.lowerEndpoint()));
        }
        return tokenRangeSet;
    }

    static final class Token
    implements Input.Token {
        private final Tok tok;
        private final ImmutableList<Tok> toksBefore;
        private final ImmutableList<Tok> toksAfter;

        Token(List<Tok> toksBefore, Tok tok, List<Tok> toksAfter) {
            this.toksBefore = ImmutableList.copyOf(toksBefore);
            this.tok = tok;
            this.toksAfter = ImmutableList.copyOf(toksAfter);
        }

        @Override
        public Tok getTok() {
            return this.tok;
        }

        @Override
        public ImmutableList<? extends Input.Tok> getToksBefore() {
            return this.toksBefore;
        }

        @Override
        public ImmutableList<? extends Input.Tok> getToksAfter() {
            return this.toksAfter;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tok", (Object)this.tok).add("toksBefore", this.toksBefore).add("toksAfter", this.toksAfter).toString();
        }
    }

    static final class Tok
    implements Input.Tok {
        private final int index;
        private final String originalText;
        private final String text;
        private final int position;
        private final int columnI;
        private final boolean isToken;
        private final int id;

        Tok(int index, String originalText, String text, int position, int columnI, boolean isToken, int id) {
            this.index = index;
            this.originalText = originalText;
            this.text = text;
            this.position = position;
            this.columnI = columnI;
            this.isToken = isToken;
            this.id = id;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String getOriginalText() {
            return this.originalText;
        }

        @Override
        public int length() {
            return this.originalText.length();
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public int getColumn() {
            return this.columnI;
        }

        boolean isToken() {
            return this.isToken;
        }

        @Override
        public boolean isNewline() {
            return "\n".equals(this.text);
        }

        @Override
        public boolean isSlashSlashComment() {
            return this.text.startsWith("//");
        }

        @Override
        public boolean isSlashStarComment() {
            return this.text.startsWith("/*");
        }

        @Override
        public boolean isJavadocComment() {
            return this.text.startsWith("/**") && this.text.length() > 4;
        }

        @Override
        public boolean isComment() {
            return this.isSlashSlashComment() || this.isSlashStarComment();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("text", (Object)this.text).add("position", this.position).add("columnI", this.columnI).add("isToken", this.isToken).toString();
        }

        public int id() {
            return this.id;
        }
    }
}

