/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.Operation;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.RequestResponseChannel;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;

public class RequestResponseOpener
implements Operation<RequestResponseChannel> {
    private final SessionProvider sessionProvider;
    private final String sessionName;
    private final String linkName;
    private final String endpointAddress;
    private final AmqpConnection eventDispatcher;

    public RequestResponseOpener(SessionProvider sessionProvider, String sessionName, String linkName, String endpointAddress, AmqpConnection eventDispatcher) {
        this.sessionProvider = sessionProvider;
        this.sessionName = sessionName;
        this.linkName = linkName;
        this.endpointAddress = endpointAddress;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public void run(final OperationResult<RequestResponseChannel, Exception> operationCallback) {
        Session session = this.sessionProvider.getSession(this.sessionName, null, new BiConsumer<ErrorCondition, Exception>(){

            @Override
            public void accept(ErrorCondition error, Exception exception) {
                if (error != null) {
                    operationCallback.onError(ExceptionUtil.toException(error));
                } else if (exception != null) {
                    operationCallback.onError(exception);
                }
            }
        });
        if (session == null) {
            return;
        }
        final RequestResponseChannel requestResponseChannel = new RequestResponseChannel(this.linkName, this.endpointAddress, session);
        requestResponseChannel.open(new OperationResult<Void, Exception>(){

            @Override
            public void onComplete(Void result) {
                RequestResponseOpener.this.eventDispatcher.registerForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.registerForConnectionError((Link)requestResponseChannel.getReceiveLink());
                operationCallback.onComplete(requestResponseChannel);
            }

            @Override
            public void onError(Exception error) {
                operationCallback.onError(error);
            }
        }, new OperationResult<Void, Exception>(){

            @Override
            public void onComplete(Void result) {
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
            }

            @Override
            public void onError(Exception error) {
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getSendLink());
                RequestResponseOpener.this.eventDispatcher.deregisterForConnectionError((Link)requestResponseChannel.getReceiveLink());
            }
        });
    }
}

