"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.rawConfigServiceMock = void 0;
const rxjs_1 = require("rxjs");
const createRawConfigServiceMock = ({ rawConfig = {}, rawConfig$ = undefined, } = {}) => {
    const mocked = {
        loadConfig: jest.fn(),
        stop: jest.fn(),
        reloadConfig: jest.fn(),
        getConfig$: jest.fn().mockReturnValue(rawConfig$ || rxjs_1.of(rawConfig)),
    };
    return mocked;
};
exports.rawConfigServiceMock = {
    create: createRawConfigServiceMock,
};
