"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var geometries_1 = require("./geometries");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var is_brushing_1 = require("./is_brushing");
exports.getHighlightedAreaSelector = re_reselect_1.default([geometries_1.geometries, get_heatmap_spec_1.getHeatmapSpecSelector, is_brushing_1.isBrushingSelector], function (geoms, spec, isBrushing) {
    if (!spec.highlightedData || isBrushing) {
        return null;
    }
    return geoms.pickHighlightedArea(spec.highlightedData.x, spec.highlightedData.y);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_highlighted_area.js.map