/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public enum DownloadParamType {
    httpUrl{

        @Override
        public List<Future<?>> download(String s, Collection<File> fileList) {
            return new OpenLocationAction().openUrl(false, s);
        }

        @Override
        public List<Future<?>> downloadGps(String s) {
            Bounds b = OsmUrlToBounds.parse(s);
            if (b == null) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Ignoring malformed URL: \"{0}\"", s), I18n.tr("Warning", new Object[0]), 2);
                return Collections.emptyList();
            }
            return MainApplication.downloadFromParamBounds(true, b);
        }
    }
    ,
    fileUrl{

        @Override
        public List<Future<?>> download(String s, Collection<File> fileList) {
            File f = null;
            try {
                f = new File(new URI(s));
            }
            catch (URISyntaxException e) {
                Logging.warn(e);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Ignoring malformed file URL: \"{0}\"", s), I18n.tr("Warning", new Object[0]), 2);
            }
            if (f != null) {
                fileList.add(f);
            }
            return Collections.emptyList();
        }
    }
    ,
    bounds{

        private List<Future<?>> downloadFromParamBounds(boolean rawGps, String s) {
            StringTokenizer st = new StringTokenizer(s, ",");
            if (st.countTokens() == 4) {
                return MainApplication.downloadFromParamBounds(rawGps, new Bounds(new LatLon(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())), new LatLon(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()))));
            }
            return Collections.emptyList();
        }

        @Override
        public List<Future<?>> download(String param, Collection<File> fileList) {
            return this.downloadFromParamBounds(false, param);
        }

        @Override
        public List<Future<?>> downloadGps(String param) {
            return this.downloadFromParamBounds(true, param);
        }
    }
    ,
    fileName{

        @Override
        public List<Future<?>> download(String s, Collection<File> fileList) {
            fileList.add(new File(s));
            return Collections.emptyList();
        }
    };


    public abstract List<Future<?>> download(String var1, Collection<File> var2);

    public List<Future<?>> downloadGps(String param) {
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
        }
        return Collections.emptyList();
    }

    public static DownloadParamType paramType(String s) {
        if (s.startsWith("http:") || s.startsWith("https:")) {
            return httpUrl;
        }
        if (s.startsWith("file:")) {
            return fileUrl;
        }
        String coorPattern = "\\s*[+-]?[0-9]+(\\.[0-9]+)?\\s*";
        if (s.matches(coorPattern + "(," + coorPattern + "){3}")) {
            return bounds;
        }
        return fileName;
    }
}

