/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Iterator;
import java.util.List;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.InstanceInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchLocalVariableReferenceVisitor;
import org.jd.core.v1.util.DefaultList;

public class InitStaticFieldVisitor
extends AbstractJavaSyntaxVisitor {
    protected SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    protected SearchLocalVariableReferenceVisitor searchLocalVariableReferenceVisitor = new SearchLocalVariableReferenceVisitor();
    protected String internalTypeName;
    protected DefaultList<FieldDeclarator> fields = new DefaultList();
    protected List<ClassFileConstructorOrMethodDeclaration> methods;
    protected Boolean deleteStaticDeclaration;

    public void setInternalTypeName(String internalTypeName) {
        this.internalTypeName = internalTypeName;
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.internalTypeName = declaration.getInternalTypeName();
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.fields.clear();
        this.safeAcceptListDeclaration(bodyDeclaration.getFieldDeclarations());
        if (!this.fields.isEmpty()) {
            this.methods = bodyDeclaration.getMethodDeclarations();
            if (this.methods != null) {
                this.deleteStaticDeclaration = null;
                int len = this.methods.size();
                for (int i = 0; i < len; ++i) {
                    this.methods.get(i).accept(this);
                    if (this.deleteStaticDeclaration == null) continue;
                    if (!this.deleteStaticDeclaration.booleanValue()) break;
                    this.methods.remove(i);
                    break;
                }
            }
        }
        this.safeAcceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
    }

    @Override
    public void visit(FieldDeclarator declaration) {
        this.fields.add(declaration);
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
    }

    @Override
    public void visit(MethodDeclaration declaration) {
    }

    @Override
    public void visit(InstanceInitializerDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
        ClassFileStaticInitializerDeclaration sid = (ClassFileStaticInitializerDeclaration)declaration;
        BaseStatement statements = sid.getStatements();
        if (statements != null) {
            if (statements.isList()) {
                if (statements.size() > 0 && this.isAssertionsDisabled((Statement)statements.getFirst())) {
                    statements.getList().removeFirst();
                }
                if (statements.size() > 0) {
                    DefaultList list = statements.getList();
                    Iterator<FieldDeclarator> fieldDeclaratorIterator = this.fields.iterator();
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        Statement statement = (Statement)list.get(i);
                        if (!this.setStaticFieldInitializer(statement, fieldDeclaratorIterator)) continue;
                        if (i > 0) {
                            BaseStatement newStatements;
                            if (i == 1) {
                                newStatements = (BaseStatement)list.removeFirst();
                            } else {
                                List<Statement> subList = list.subList(0, i);
                                newStatements = new Statements(subList);
                                subList.clear();
                            }
                            len -= newStatements.size();
                            i = 0;
                            this.addStaticInitializerDeclaration(sid, this.getFirstLineNumber(newStatements), newStatements);
                        }
                        list.remove(i--);
                        --len;
                    }
                }
            } else {
                if (this.isAssertionsDisabled((Statement)statements.getFirst())) {
                    statements = null;
                }
                if (statements != null && this.setStaticFieldInitializer((Statement)statements.getFirst(), this.fields.iterator())) {
                    statements = null;
                }
            }
            if (statements == null || statements.size() == 0) {
                this.deleteStaticDeclaration = Boolean.TRUE;
            } else {
                int firstLineNumber = this.getFirstLineNumber(statements);
                sid.setFirstLineNumber(firstLineNumber == -1 ? 0 : firstLineNumber);
                this.deleteStaticDeclaration = Boolean.FALSE;
            }
        }
    }

    protected boolean isAssertionsDisabled(Statement statement) {
        FieldReferenceExpression fre;
        BinaryOperatorExpression cfboe;
        ExpressionStatement cdes;
        return statement.getClass() == ExpressionStatement.class && (cdes = (ExpressionStatement)statement).getExpression().getClass() == BinaryOperatorExpression.class && (cfboe = (BinaryOperatorExpression)cdes.getExpression()).getLeftExpression().getClass() == FieldReferenceExpression.class && (fre = (FieldReferenceExpression)cfboe.getLeftExpression()).getType() == PrimitiveType.TYPE_BOOLEAN && fre.getInternalTypeName().equals(this.internalTypeName) && fre.getName().equals("$assertionsDisabled");
    }

    protected boolean setStaticFieldInitializer(Statement statement, Iterator<FieldDeclarator> fieldDeclaratorIterator) {
        FieldReferenceExpression fre;
        BinaryOperatorExpression cfboe;
        ExpressionStatement cdes;
        if (statement.getClass() == ExpressionStatement.class && (cdes = (ExpressionStatement)statement).getExpression().getClass() == BinaryOperatorExpression.class && (cfboe = (BinaryOperatorExpression)cdes.getExpression()).getLeftExpression().getClass() == FieldReferenceExpression.class && (fre = (FieldReferenceExpression)cfboe.getLeftExpression()).getInternalTypeName().equals(this.internalTypeName)) {
            while (fieldDeclaratorIterator.hasNext()) {
                FieldDeclarator fdr = fieldDeclaratorIterator.next();
                FieldDeclaration fdn = fdr.getFieldDeclaration();
                if ((fdn.getFlags() & 8) == 0 || !fdr.getName().equals(fre.getName()) || !fdn.getType().getDescriptor().equals(fre.getDescriptor())) continue;
                Expression expression = cfboe.getRightExpression();
                this.searchLocalVariableReferenceVisitor.init(-1);
                expression.accept(this.searchLocalVariableReferenceVisitor);
                if (this.searchLocalVariableReferenceVisitor.containsReference()) {
                    return false;
                }
                fdr.setVariableInitializer(new ExpressionVariableInitializer(expression));
                ((ClassFileFieldDeclaration)fdr.getFieldDeclaration()).setFirstLineNumber(expression.getLineNumber());
                return true;
            }
        }
        return false;
    }

    protected int getFirstLineNumber(BaseStatement baseStatement) {
        this.searchFirstLineNumberVisitor.init();
        baseStatement.accept(this.searchFirstLineNumberVisitor);
        return this.searchFirstLineNumberVisitor.getLineNumber();
    }

    protected void addStaticInitializerDeclaration(ClassFileStaticInitializerDeclaration sid, int lineNumber, BaseStatement statements) {
        this.methods.add(new ClassFileStaticInitializerDeclaration(sid.getBodyDeclaration(), sid.getClassFile(), sid.getMethod(), sid.getBindings(), sid.getTypeBounds(), lineNumber, statements));
    }
}

