/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.JumpPosition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeArea
extends RSyntaxTextArea {
    private static final long serialVersionUID = -3980354865216031972L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodeArea.class);
    protected final ContentPanel contentPanel;
    protected final JNode node;

    public AbstractCodeArea(ContentPanel contentPanel) {
        this.contentPanel = contentPanel;
        this.node = contentPanel.getNode();
        this.setMarkOccurrences(true);
        this.setEditable(false);
        this.setCodeFoldingEnabled(false);
        this.loadSettings();
        Caret caret = this.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(2);
        }
        caret.setVisible(true);
        this.registerWordHighlighter();
    }

    public abstract void load();

    public static RSyntaxTextArea getDefaultArea(MainWindow mainWindow) {
        RSyntaxTextArea area = new RSyntaxTextArea();
        area.setEditable(false);
        area.setCodeFoldingEnabled(false);
        AbstractCodeArea.loadCommonSettings(mainWindow, area);
        return area;
    }

    public static void loadCommonSettings(MainWindow mainWindow, RSyntaxTextArea area) {
        area.setAntiAliasingEnabled(true);
        mainWindow.getEditorTheme().apply(area);
        JadxSettings settings = mainWindow.getSettings();
        area.setFont(settings.getFont());
    }

    public void loadSettings() {
        AbstractCodeArea.loadCommonSettings(this.contentPanel.getTabbedPane().getMainWindow(), this);
    }

    public void scrollToLine(int line) {
        int lineNum = line - 1;
        if (lineNum < 0) {
            lineNum = 0;
        }
        this.setCaretAtLine(lineNum);
        this.centerCurrentLine();
        this.forceCurrentLineHighlightRepaint();
    }

    private void setCaretAtLine(int line) {
        try {
            this.setCaretPosition(this.getLineStartOffset(line));
        }
        catch (BadLocationException e) {
            LOG.debug("Can't scroll to {}", (Object)line, (Object)e);
        }
    }

    public void centerCurrentLine() {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, (Component)((Object)this));
        if (viewport == null) {
            return;
        }
        try {
            Rectangle r = this.modelToView(this.getCaretPosition());
            if (r == null) {
                return;
            }
            int extentHeight = viewport.getExtentSize().height;
            Dimension viewSize = viewport.getViewSize();
            if (viewSize == null) {
                return;
            }
            int viewHeight = viewSize.height;
            int y = Math.max(0, r.y - extentHeight / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException e) {
            LOG.debug("Can't center current line", (Throwable)e);
        }
    }

    private void registerWordHighlighter() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() % 2 == 0 && !evt.isConsumed()) {
                    evt.consume();
                    String str = AbstractCodeArea.this.getSelectedText();
                    if (str != null) {
                        AbstractCodeArea.this.highlightAllMatches(str);
                    }
                } else {
                    AbstractCodeArea.this.highlightAllMatches(null);
                }
            }
        });
    }

    private void highlightAllMatches(@Nullable String str) {
        SearchContext context = new SearchContext(str);
        context.setMarkAll(true);
        context.setMatchCase(true);
        context.setWholeWord(true);
        SearchEngine.markAll((RTextArea)this, (SearchContext)context);
    }

    public JumpPosition getCurrentPosition() {
        return new JumpPosition(this.node, this.getCaretLineNumber() + 1);
    }

    @Nullable
    Integer getSourceLine(int line) {
        return this.node.getSourceLine(line);
    }

    public ContentPanel getContentPanel() {
        return this.contentPanel;
    }

    public JNode getNode() {
        return this.node;
    }
}

