/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapUsageBar
extends JProgressBar
implements ActionListener {
    private static final Logger LOG = LoggerFactory.getLogger(HeapUsageBar.class);
    private static final long serialVersionUID = -8739563124249884967L;
    private static final double TWO_TO_20 = 1048576.0;
    private static final Color GREEN = new Color(0, 180, 0);
    private static final Color RED = new Color(200, 0, 0);
    private final transient Runtime runtime = Runtime.getRuntime();
    private final transient Timer timer;
    private final double maxGB;

    public HeapUsageBar() {
        this.setBorderPainted(false);
        this.setStringPainted(true);
        this.setValue(10);
        int maxKB = (int)(this.runtime.maxMemory() / 1024L);
        this.setMaximum(maxKB);
        this.maxGB = (double)maxKB / 1048576.0;
        this.update();
        this.timer = new Timer(2000, this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Runtime.getRuntime().gc();
                HeapUsageBar.this.update();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Memory used: {}", (Object)UiUtils.memoryInfo());
                }
            }
        });
    }

    public void update() {
        long used = this.runtime.totalMemory() - this.runtime.freeMemory();
        int usedKB = (int)(used / 1024L);
        this.setValue(usedKB);
        this.setString(NLS.str("heapUsage.text", (double)usedKB / 1048576.0, this.maxGB));
        if (used + UiUtils.MIN_FREE_MEMORY > this.runtime.maxMemory()) {
            this.setForeground(RED);
        } else {
            this.setForeground(GREEN);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }
}

