/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.conditions;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBranchRegion;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.AbstractRegion;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.utils.BlockUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class IfRegion
extends AbstractRegion
implements IBranchRegion {
    private List<BlockNode> conditionBlocks;
    private IfCondition condition;
    private IContainer thenRegion;
    private IContainer elseRegion;

    public IfRegion(IRegion parent) {
        super(parent);
    }

    public IfCondition getCondition() {
        return this.condition;
    }

    public void setCondition(IfCondition condition) {
        this.condition = condition;
    }

    public IContainer getThenRegion() {
        return this.thenRegion;
    }

    public void setThenRegion(IContainer thenRegion) {
        this.thenRegion = thenRegion;
    }

    public IContainer getElseRegion() {
        return this.elseRegion;
    }

    public void setElseRegion(IContainer elseRegion) {
        this.elseRegion = elseRegion;
    }

    public List<BlockNode> getConditionBlocks() {
        return this.conditionBlocks;
    }

    public void setConditionBlocks(List<BlockNode> conditionBlocks) {
        this.conditionBlocks = conditionBlocks;
    }

    public void setConditionBlocks(Set<BlockNode> conditionBlocks) {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>(conditionBlocks);
        Collections.sort(list);
        this.conditionBlocks = list;
    }

    public boolean simplifyCondition() {
        IfCondition cond = IfCondition.simplify(this.condition);
        if (cond != this.condition) {
            this.condition = cond;
            return true;
        }
        return false;
    }

    public void invert() {
        this.condition = IfCondition.invert(this.condition);
        IContainer tmp = this.thenRegion;
        this.thenRegion = this.elseRegion;
        this.elseRegion = tmp;
    }

    public int getSourceLine() {
        for (BlockNode block : this.conditionBlocks) {
            int sourceLine;
            InsnNode lastInsn = BlockUtils.getLastInsn(block);
            if (lastInsn == null || (sourceLine = lastInsn.getSourceLine()) == 0) continue;
            return sourceLine;
        }
        return 0;
    }

    @Override
    public List<IContainer> getSubBlocks() {
        ArrayList<IContainer> all = new ArrayList<IContainer>(this.conditionBlocks.size() + 2);
        all.addAll(this.conditionBlocks);
        if (this.thenRegion != null) {
            all.add(this.thenRegion);
        }
        if (this.elseRegion != null) {
            all.add(this.elseRegion);
        }
        return Collections.unmodifiableList(all);
    }

    @Override
    public List<IContainer> getBranches() {
        ArrayList<IContainer> branches = new ArrayList<IContainer>(2);
        branches.add(this.thenRegion);
        branches.add(this.elseRegion);
        return Collections.unmodifiableList(branches);
    }

    @Override
    public boolean replaceSubBlock(IContainer oldBlock, IContainer newBlock) {
        if (oldBlock == this.thenRegion) {
            this.thenRegion = newBlock;
            this.updateParent(this.thenRegion, this);
            return true;
        }
        if (oldBlock == this.elseRegion) {
            this.elseRegion = newBlock;
            this.updateParent(this.elseRegion, this);
            return true;
        }
        return false;
    }

    @Override
    public String baseString() {
        StringBuilder sb = new StringBuilder();
        if (this.thenRegion != null) {
            sb.append(this.thenRegion.baseString());
        }
        if (this.elseRegion != null) {
            sb.append(this.elseRegion.baseString());
        }
        return sb.toString();
    }

    public String toString() {
        return "IF " + this.conditionBlocks + " THEN: " + this.thenRegion + " ELSE: " + this.elseRegion;
    }
}

