/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteAppletAction;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExtendedAppletSecurityHelp;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;

public abstract class AppTrustWarningPanel
extends JPanel {
    protected int PANE_WIDTH = 500;
    protected int TOP_PANEL_HEIGHT = 60;
    protected int INFO_PANEL_HEIGHT = 160;
    protected int INFO_PANEL_HINT_HEIGHT = 25;
    protected int QUESTION_PANEL_HEIGHT = 35;
    protected List<JButton> buttons;
    protected JButton allowButton;
    protected JButton rejectButton;
    protected JButton helpButton;
    protected JCheckBox permanencyCheckBox;
    protected JRadioButton applyToAppletButton;
    protected JRadioButton applyToCodeBaseButton;
    protected JNLPFile file;
    protected ActionChoiceListener actionChoiceListener;

    public AppTrustWarningPanel(JNLPFile file, ActionChoiceListener actionChoiceListener) {
        this.file = file;
        this.actionChoiceListener = actionChoiceListener;
        this.buttons = new ArrayList<JButton>();
        this.allowButton = new JButton(Translator.R("ButProceed"));
        this.rejectButton = new JButton(Translator.R("ButCancel"));
        this.helpButton = new JButton(Translator.R("APPEXTSECguiPanelHelpButton"));
        this.allowButton.addActionListener(this.chosenActionSetter(ExecuteAppletAction.YES));
        this.rejectButton.addActionListener(this.chosenActionSetter(ExecuteAppletAction.NO));
        this.helpButton.addActionListener(this.getHelpButtonAction());
        this.buttons.add(this.allowButton);
        this.buttons.add(this.rejectButton);
        this.buttons.add(this.helpButton);
    }

    protected abstract ImageIcon getInfoImage();

    protected abstract String getTopPanelText();

    protected abstract String getInfoPanelText();

    protected abstract String getQuestionPanelText();

    public final JButton getAllowButton() {
        return this.allowButton;
    }

    public final JButton getRejectButton() {
        return this.rejectButton;
    }

    protected ActionListener getHelpButtonAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedAppletSecurityHelp d = new ExtendedAppletSecurityHelp(null, false, "dialogue");
                ScreenFinder.centerWindowsToCurrentScreen(d);
                d.setVisible(true);
            }
        };
    }

    protected static String htmlWrap(String text) {
        return "<html>" + text + "</html>";
    }

    private void setupTopPanel() {
        String topLabelText = this.getTopPanelText();
        JLabel topLabel = new JLabel(topLabelText, this.getInfoImage(), 2);
        topLabel.setFont(new Font(topLabel.getFont().toString(), 1, 12));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        topPanel.add((Component)topLabel, "Center");
        topPanel.setPreferredSize(new Dimension(this.PANE_WIDTH, this.TOP_PANEL_HEIGHT));
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(topPanel);
    }

    protected String getAppletTitle() {
        String title;
        try {
            title = this.file instanceof PluginBridge ? this.file.getTitle() : this.file.getInformation().getTitle();
        }
        catch (Exception e) {
            title = "";
        }
        return title;
    }

    private void setupInfoPanel() {
        JPanel infoPanel = new JPanel(new BorderLayout());
        String titleText = this.getAppletTitle();
        JLabel titleLabel = new JLabel(titleText);
        titleLabel.setFont(new Font(titleLabel.getFont().getName(), 1, 18));
        String infoLabelText = this.getInfoPanelText();
        JEditorPane infoLabel = new JEditorPane("text/html", AppTrustWarningPanel.htmlWrap(infoLabelText));
        infoLabel.setBackground(infoPanel.getBackground());
        infoLabel.setEditable(false);
        infoLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                }
                catch (IOException ex) {
                    OutputController.getLogger().log(ex);
                }
                catch (URISyntaxException ex) {
                    OutputController.getLogger().log(ex);
                }
            }
        });
        int panelHeight = titleLabel.getHeight() + this.INFO_PANEL_HEIGHT + this.INFO_PANEL_HINT_HEIGHT;
        infoPanel.add((Component)titleLabel, "First");
        infoPanel.add((Component)infoLabel, "Center");
        infoPanel.setPreferredSize(new Dimension(this.PANE_WIDTH, panelHeight));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(infoPanel);
    }

    private void setupQuestionsPanel() {
        JPanel questionPanel = new JPanel(new BorderLayout());
        String questionPanelText = this.getQuestionPanelText();
        questionPanel.add((Component)new JLabel(questionPanelText), "East");
        questionPanel.setPreferredSize(new Dimension(this.PANE_WIDTH, this.QUESTION_PANEL_HEIGHT));
        questionPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.add(questionPanel);
    }

    private JPanel createMatchOptionsPanel() {
        JPanel matchOptionsPanel = new JPanel(new FlowLayout(0));
        ButtonGroup group = new ButtonGroup();
        this.applyToAppletButton = new JRadioButton(Translator.R("SRememberAppletOnly"));
        this.applyToAppletButton.setSelected(true);
        this.applyToAppletButton.setEnabled(false);
        this.applyToCodeBaseButton = new JRadioButton(AppTrustWarningPanel.htmlWrap(Translator.R("SRememberCodebase", this.file.getCodeBase())));
        this.applyToCodeBaseButton.setEnabled(false);
        group.add(this.applyToAppletButton);
        group.add(this.applyToCodeBaseButton);
        matchOptionsPanel.add(this.applyToAppletButton);
        matchOptionsPanel.add(this.applyToCodeBaseButton);
        return matchOptionsPanel;
    }

    private JPanel createCheckBoxPanel() {
        JPanel checkBoxPanel = new JPanel(new BorderLayout());
        this.permanencyCheckBox = new JCheckBox(AppTrustWarningPanel.htmlWrap(Translator.R("SRememberOption")));
        this.permanencyCheckBox.addActionListener(this.permanencyListener());
        checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        checkBoxPanel.add((Component)this.permanencyCheckBox, "South");
        return checkBoxPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        for (JButton button : this.buttons) {
            buttonPanel.add(button);
        }
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return buttonPanel;
    }

    private void setupButtonAndCheckBoxPanel() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel rememberPanel = new JPanel(new GridLayout(2, 1));
        rememberPanel.add(this.createMatchOptionsPanel());
        rememberPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        outerPanel.add((Component)this.createCheckBoxPanel(), "West");
        outerPanel.add((Component)rememberPanel, "South");
        outerPanel.add((Component)this.createButtonPanel(), "East");
        this.add(outerPanel);
    }

    protected final void addComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.setupTopPanel();
        this.setupInfoPanel();
        this.setupQuestionsPanel();
        this.setupButtonAndCheckBoxPanel();
    }

    protected ActionListener permanencyListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppTrustWarningPanel.this.applyToAppletButton.setEnabled(AppTrustWarningPanel.this.permanencyCheckBox.isSelected());
                AppTrustWarningPanel.this.applyToCodeBaseButton.setEnabled(AppTrustWarningPanel.this.permanencyCheckBox.isSelected());
            }
        };
    }

    protected ActionListener chosenActionSetter(final ExecuteAppletAction action) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteAppletAction realAction = action == ExecuteAppletAction.YES ? (AppTrustWarningPanel.this.permanencyCheckBox.isSelected() ? ExecuteAppletAction.ALWAYS : ExecuteAppletAction.YES) : (action == ExecuteAppletAction.NO ? (AppTrustWarningPanel.this.permanencyCheckBox.isSelected() ? ExecuteAppletAction.NEVER : ExecuteAppletAction.NO) : action);
                boolean applyToCodeBase = AppTrustWarningPanel.this.applyToCodeBaseButton.isSelected();
                AppTrustWarningPanel.this.actionChoiceListener.actionChosen(new AppSigningWarningAction(realAction, applyToCodeBase));
            }
        };
    }

    public static interface ActionChoiceListener {
        public void actionChosen(AppSigningWarningAction var1);
    }

    public static class AppSigningWarningAction {
        private ExecuteAppletAction action;
        private boolean applyToCodeBase;

        public AppSigningWarningAction(ExecuteAppletAction action, boolean applyToCodeBase) {
            this.action = action;
            this.applyToCodeBase = applyToCodeBase;
        }

        public ExecuteAppletAction getAction() {
            return this.action;
        }

        public boolean rememberForCodeBase() {
            return this.applyToCodeBase;
        }
    }
}

