/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import net.i2p.util.SimpleByteCache;

class I2PHMac {
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private final MessageDigest digest;
    private final int digestSize;
    private final byte[] inputPad = new byte[64];
    private final byte[] outputPad = new byte[64];

    @Deprecated
    public I2PHMac(MessageDigest digest) {
        this(digest, digest.getDigestLength());
    }

    public I2PHMac(MessageDigest digest, int sz) {
        this.digest = digest;
        this.digestSize = sz;
    }

    public String getAlgorithmName() {
        return this.digest.getAlgorithm() + "/HMAC";
    }

    public MessageDigest getUnderlyingDigest() {
        return this.digest;
    }

    public void init(byte[] key) {
        int i;
        this.digest.reset();
        if (key.length > 64) {
            this.digest.update(key, 0, key.length);
            try {
                this.digest.digest(this.inputPad, 0, this.digestSize);
            }
            catch (DigestException de) {
                this.digest.reset();
                throw new IllegalArgumentException(de);
            }
            for (i = this.digestSize; i < this.inputPad.length; ++i) {
                this.inputPad[i] = 0;
            }
        } else {
            System.arraycopy(key, 0, this.inputPad, 0, key.length);
            for (i = key.length; i < this.inputPad.length; ++i) {
                this.inputPad[i] = 0;
            }
        }
        System.arraycopy(this.inputPad, 0, this.outputPad, 0, this.inputPad.length);
        i = 0;
        while (i < this.inputPad.length) {
            int n = i++;
            this.inputPad[n] = (byte)(this.inputPad[n] ^ 0x36);
        }
        i = 0;
        while (i < this.outputPad.length) {
            int n = i++;
            this.outputPad[n] = (byte)(this.outputPad[n] ^ 0x5C);
        }
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    public int getMacSize() {
        return this.digestSize;
    }

    public void update(byte in) {
        this.digest.update(in);
    }

    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = I2PHMac.acquireTmp(this.digestSize);
        try {
            this.digest.digest(tmp, 0, this.digestSize);
            this.digest.update(this.outputPad, 0, this.outputPad.length);
            this.digest.update(tmp, 0, tmp.length);
            int n = this.digest.digest(out, outOff, this.digestSize);
            return n;
        }
        catch (DigestException de) {
            throw new IllegalArgumentException(de);
        }
        finally {
            I2PHMac.releaseTmp(tmp);
            this.reset();
        }
    }

    private static byte[] acquireTmp(int sz) {
        byte[] rv = SimpleByteCache.acquire(sz);
        Arrays.fill(rv, (byte)0);
        return rv;
    }

    private static void releaseTmp(byte[] buf) {
        SimpleByteCache.release(buf);
    }

    public void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }
}

