/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.data.router.RouterInfo;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class Republish
implements SimpleTimer.TimedEvent {
    private final RouterContext _context;

    public Republish(RouterContext ctx) {
        this._context = ctx;
    }

    @Override
    public void timeReached() {
        try {
            RouterInfo ri = this._context.router().getRouterInfo();
            if (ri != null) {
                this._context.netDb().publish(ri);
            }
        }
        catch (IllegalArgumentException iae) {
            Log log = this._context.logManager().getLog(Router.class);
            log.log(50, "Local router info is invalid?  rebuilding a new identity", iae);
            this._context.router().rebuildNewIdentity();
        }
    }
}

