/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import com.southernstorm.noise.protocol.HandshakeState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyFactory;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.X25519KeyFactory;
import net.i2p.util.Log;

public class BuildRequestRecord {
    private final byte[] _data;
    private final boolean _isEC;
    private SessionKey _chachaReplyKey;
    private byte[] _chachaReplyAD;
    private static final int FLAG_UNRESTRICTED_PREV = 128;
    private static final int FLAG_OUTBOUND_ENDPOINT = 64;
    public static final int IV_SIZE = 16;
    public static final int PEER_SIZE = 16;
    private static final int DEFAULT_EXPIRATION_SECONDS = 600;
    private static final int EC_LEN = EncType.ECIES_X25519.getPubkeyLen();
    private static final byte[] NULL_KEY = new byte[EC_LEN];
    private static final int OFF_RECV_TUNNEL = 0;
    private static final int OFF_OUR_IDENT = 4;
    private static final int OFF_SEND_TUNNEL = 36;
    private static final int OFF_SEND_IDENT = 40;
    private static final int OFF_LAYER_KEY = 72;
    private static final int OFF_IV_KEY = 104;
    public static final int OFF_REPLY_KEY = 136;
    private static final int OFF_REPLY_IV = 168;
    private static final int OFF_FLAG = 184;
    private static final int OFF_REQ_TIME = 185;
    private static final int OFF_SEND_MSG_ID = 189;
    private static final int PADDING_SIZE = 29;
    private static final int LENGTH = 222;
    private static final int OFF_SEND_TUNNEL_EC = 4;
    private static final int OFF_SEND_IDENT_EC = 8;
    private static final int OFF_LAYER_KEY_EC = 40;
    private static final int OFF_IV_KEY_EC = 72;
    public static final int OFF_REPLY_KEY_EC = 104;
    private static final int OFF_REPLY_IV_EC = 136;
    private static final int OFF_FLAG_EC = 152;
    private static final int OFF_REQ_TIME_EC = 156;
    private static final int OFF_EXPIRATION = 160;
    private static final int OFF_SEND_MSG_ID_EC = 164;
    private static final int OFF_OPTIONS = 168;
    private static final int LENGTH_EC = 464;
    private static final int MAX_OPTIONS_LENGTH = 296;
    private static final boolean TEST = false;
    private static KeyFactory TESTKF;

    public byte[] getData() {
        return this._data;
    }

    public long readReceiveTunnelId() {
        return DataHelper.fromLong(this._data, 0, 4);
    }

    public long readNextTunnelId() {
        int off = this._isEC ? 4 : 36;
        return DataHelper.fromLong(this._data, off, 4);
    }

    public Hash readNextIdentity() {
        int off = this._isEC ? 8 : 40;
        return Hash.create(this._data, off);
    }

    public SessionKey readLayerKey() {
        byte[] key = new byte[32];
        int off = this._isEC ? 40 : 72;
        System.arraycopy(this._data, off, key, 0, 32);
        return new SessionKey(key);
    }

    public SessionKey readIVKey() {
        byte[] key = new byte[32];
        int off = this._isEC ? 72 : 104;
        System.arraycopy(this._data, off, key, 0, 32);
        return new SessionKey(key);
    }

    public SessionKey readReplyKey() {
        byte[] key = new byte[32];
        int off = this._isEC ? 104 : 136;
        System.arraycopy(this._data, off, key, 0, 32);
        return new SessionKey(key);
    }

    public byte[] readReplyIV() {
        byte[] iv = new byte[16];
        int off = this._isEC ? 136 : 168;
        System.arraycopy(this._data, off, iv, 0, 16);
        return iv;
    }

    public boolean readIsInboundGateway() {
        int off = this._isEC ? 152 : 184;
        return (this._data[off] & 0x80) != 0;
    }

    public boolean readIsOutboundEndpoint() {
        int off = this._isEC ? 152 : 184;
        return (this._data[off] & 0x40) != 0;
    }

    public long readRequestTime() {
        if (this._isEC) {
            return DataHelper.fromLong(this._data, 156, 4) * 60000L;
        }
        return DataHelper.fromLong(this._data, 185, 4) * 3600000L;
    }

    public long readReplyMessageId() {
        int off = this._isEC ? 164 : 189;
        return DataHelper.fromLong(this._data, off, 4);
    }

    public long readExpiration() {
        if (!this._isEC) {
            return 600000L;
        }
        return DataHelper.fromLong(this._data, 160, 4) * 1000L;
    }

    public Properties readOptions() {
        if (!this._isEC) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this._data, 168, 296);
        try {
            return DataHelper.readProperties(in, null);
        }
        catch (DataFormatException dfe) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public EncryptedBuildRecord encryptRecord(I2PAppContext ctx, PublicKey toKey, Hash toPeer) {
        EncType type = toKey.getType();
        if (type != EncType.ELGAMAL_2048) {
            throw new IllegalArgumentException();
        }
        byte[] out = new byte[528];
        System.arraycopy(toPeer.getData(), 0, out, 0, 16);
        byte[] encrypted = ctx.elGamalEngine().encrypt(this._data, toKey);
        System.arraycopy(encrypted, 1, out, 16, 256);
        System.arraycopy(encrypted, 258, out, 272, 256);
        return new EncryptedBuildRecord(out);
    }

    public EncryptedBuildRecord encryptECIESRecord(RouterContext ctx, PublicKey toKey, Hash toPeer) {
        EncType type = toKey.getType();
        if (type != EncType.ECIES_X25519) {
            throw new IllegalArgumentException();
        }
        byte[] out = new byte[528];
        System.arraycopy(toPeer.getData(), 0, out, 0, 16);
        HandshakeState state = null;
        try {
            X25519KeyFactory kf = ctx.commSystem().getXDHFactory();
            state = new HandshakeState("N", 1, kf);
            state.getRemotePublicKey().setPublicKey(toKey.getData(), 0);
            state.start();
            state.writeMessage(out, 16, this._data, 0, 464);
            EncryptedBuildRecord rv = new EncryptedBuildRecord(out);
            this._chachaReplyKey = new SessionKey(state.getChainingKey());
            this._chachaReplyAD = new byte[32];
            System.arraycopy(state.getHandshakeHash(), 0, this._chachaReplyAD, 0, 32);
            EncryptedBuildRecord encryptedBuildRecord = rv;
            return encryptedBuildRecord;
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("failed", gse);
        }
        finally {
            if (state != null) {
                state.destroy();
            }
        }
    }

    public SessionKey getChaChaReplyKey() {
        return this._chachaReplyKey;
    }

    public byte[] getChaChaReplyAD() {
        return this._chachaReplyAD;
    }

    public BuildRequestRecord(RouterContext ctx, PrivateKey ourKey, EncryptedBuildRecord encryptedRecord) throws DataFormatException {
        byte[] decrypted;
        byte[] encrypted = encryptedRecord.getData();
        EncType type = ourKey.getType();
        if (type == EncType.ELGAMAL_2048) {
            byte[] preDecrypt = new byte[514];
            System.arraycopy(encrypted, 16, preDecrypt, 1, 256);
            System.arraycopy(encrypted, 272, preDecrypt, 258, 256);
            decrypted = ctx.elGamalEngine().decrypt(preDecrypt, ourKey);
            this._isEC = false;
        } else if (type == EncType.ECIES_X25519) {
            if ((encrypted[16 + EC_LEN - 1] & 0x80) != 0) {
                throw new DataFormatException("Bad PK decrypt fail");
            }
            if (DataHelper.eq(ourKey.toPublic().getData(), 0, encrypted, 16, EC_LEN)) {
                throw new DataFormatException("Our PK decrypt fail");
            }
            if (DataHelper.eq(NULL_KEY, 0, encrypted, 16, EC_LEN)) {
                throw new DataFormatException("Null PK decrypt fail");
            }
            HandshakeState state = null;
            try {
                X25519KeyFactory kf = ctx.commSystem().getXDHFactory();
                state = new HandshakeState("N", 2, kf);
                state.getLocalKeyPair().setKeys(ourKey.getData(), 0, ourKey.toPublic().getData(), 0);
                state.start();
                decrypted = new byte[464];
                state.readMessage(encrypted, 16, 512, decrypted, 0);
                this._chachaReplyKey = new SessionKey(state.getChainingKey());
                this._chachaReplyAD = new byte[32];
                System.arraycopy(state.getHandshakeHash(), 0, this._chachaReplyAD, 0, 32);
            }
            catch (GeneralSecurityException gse) {
                Log log;
                if (state != null && (log = ctx.logManager().getLog(BuildRequestRecord.class)).shouldInfo()) {
                    log.info("ECIES BRR decrypt failure, state at failure:\n" + state);
                }
                throw new DataFormatException("ChaCha decrypt fail", gse);
            }
            finally {
                if (state != null) {
                    state.destroy();
                }
            }
            this._isEC = true;
        } else {
            throw new DataFormatException("Unsupported EncType " + (Object)((Object)type));
        }
        if (decrypted == null) {
            throw new DataFormatException("decrypt fail");
        }
        this._data = decrypted;
    }

    public BuildRequestRecord(I2PAppContext ctx, long receiveTunnelId, Hash peer, long nextTunnelId, Hash nextHop, long nextMsgId, SessionKey layerKey, SessionKey ivKey, SessionKey replyKey, byte[] iv, boolean isInGateway, boolean isOutEndpoint) {
        byte[] buf = new byte[222];
        this._data = buf;
        this._isEC = false;
        DataHelper.toLong(buf, 0, 4, receiveTunnelId);
        System.arraycopy(peer.getData(), 0, buf, 4, 32);
        DataHelper.toLong(buf, 36, 4, nextTunnelId);
        System.arraycopy(nextHop.getData(), 0, buf, 40, 32);
        System.arraycopy(layerKey.getData(), 0, buf, 72, 32);
        System.arraycopy(ivKey.getData(), 0, buf, 104, 32);
        System.arraycopy(replyKey.getData(), 0, buf, 136, 32);
        System.arraycopy(iv, 0, buf, 168, 16);
        if (isInGateway) {
            buf[184] = (byte)(buf[184] | 0x80);
        } else if (isOutEndpoint) {
            buf[184] = (byte)(buf[184] | 0x40);
        }
        long truncatedHour = ctx.clock().now();
        truncatedHour -= (long)ctx.random().nextInt(90000);
        DataHelper.toLong(buf, 185, 4, truncatedHour /= 3600000L);
        DataHelper.toLong(buf, 189, 4, nextMsgId);
        ctx.random().nextBytes(buf, 193, 29);
    }

    public BuildRequestRecord(I2PAppContext ctx, long receiveTunnelId, long nextTunnelId, Hash nextHop, long nextMsgId, SessionKey layerKey, SessionKey ivKey, SessionKey replyKey, byte[] iv, boolean isInGateway, boolean isOutEndpoint, Properties options) {
        byte[] buf = new byte[464];
        this._data = buf;
        this._isEC = true;
        DataHelper.toLong(buf, 0, 4, receiveTunnelId);
        DataHelper.toLong(buf, 4, 4, nextTunnelId);
        System.arraycopy(nextHop.getData(), 0, buf, 8, 32);
        System.arraycopy(layerKey.getData(), 0, buf, 40, 32);
        System.arraycopy(ivKey.getData(), 0, buf, 72, 32);
        System.arraycopy(replyKey.getData(), 0, buf, 104, 32);
        System.arraycopy(iv, 0, buf, 136, 16);
        if (isInGateway) {
            buf[152] = (byte)(buf[152] | 0x80);
        } else if (isOutEndpoint) {
            buf[152] = (byte)(buf[152] | 0x40);
        }
        long truncatedMinute = ctx.clock().now();
        truncatedMinute -= (long)ctx.random().nextInt(2048);
        DataHelper.toLong(buf, 156, 4, truncatedMinute /= 60000L);
        DataHelper.toLong(buf, 160, 4, 600L);
        DataHelper.toLong(buf, 164, 4, nextMsgId);
        try {
            int off = DataHelper.toProperties(buf, 168, options);
            int sz = 464 - off;
            if (sz > 0) {
                ctx.random().nextBytes(buf, off, sz);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("options", e);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this._isEC ? "ECIES" : "ElGamal");
        buf.append(" BRR ");
        boolean isIBGW = this.readIsInboundGateway();
        boolean isOBEP = this.readIsOutboundEndpoint();
        if (isIBGW) {
            buf.append("IBGW in: ").append(this.readReceiveTunnelId()).append(" out ").append(this.readNextTunnelId());
        } else if (isOBEP) {
            buf.append("OBEP in: ").append(this.readReceiveTunnelId());
        } else {
            buf.append("part. in: ").append(this.readReceiveTunnelId()).append(" out: ").append(this.readNextTunnelId());
        }
        buf.append(" to: ").append(this.readNextIdentity()).append(" layer key: ").append(this.readLayerKey()).append(" IV key: ").append(this.readIVKey()).append(" reply key: ").append(this.readReplyKey()).append(" reply IV: ").append(Base64.encode(this.readReplyIV())).append(" time: ").append(DataHelper.formatTime(this.readRequestTime())).append(" reply msg id: ").append(this.readReplyMessageId()).append(" expires in: ").append(DataHelper.formatDuration(this.readExpiration()));
        if (this._isEC) {
            buf.append(" options: ").append(this.readOptions());
            if (this._chachaReplyKey != null) {
                buf.append(" chacha reply key: ").append(this._chachaReplyKey).append(" chacha reply IV: ").append(Base64.encode(this._chachaReplyAD));
            }
        }
        return buf.toString();
    }
}

