/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.PickToolDialog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolAssociationInfo;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import resources.ResourceManager;

class SetToolAssociationsDialog
extends DialogComponentProvider {
    private final FrontEndTool tool;
    private ToolAssociationTableModel model;
    private GTable table;

    SetToolAssociationsDialog(FrontEndTool tool) {
        super("Set Tool Associations", true);
        this.tool = tool;
        this.setHelpLocation(new HelpLocation("Tool", "Set Tool Associations"));
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setPreferredSize(400, 400);
        this.setRememberLocation(false);
    }

    private JComponent createWorkPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.model = new ToolAssociationTableModel();
        this.table = new GTable((TableModel)((Object)this.model));
        JButton editButton = new JButton("Edit");
        editButton.addActionListener(e -> {
            int selectedRow = this.table.getSelectedRow();
            ToolAssociationInfo info = (ToolAssociationInfo)this.model.getRowObject(selectedRow);
            if (info == null) {
                return;
            }
            ContentHandler contentHandler = info.getContentHandler();
            Class<? extends DomainObject> domainClass = contentHandler.getDomainObjectClass();
            PickToolDialog dialog = new PickToolDialog(this.tool, domainClass);
            dialog.showDialog();
            ToolTemplate template = dialog.getSelectedToolTemplate();
            if (template != null) {
                info.setCurrentTool(template);
                this.model.fireTableDataChanged();
            }
        });
        editButton.setEnabled(false);
        JButton resetButton = new JButton("Restore Default");
        resetButton.addActionListener(e -> {
            int selectedRow = this.table.getSelectedRow();
            ToolAssociationInfo info = (ToolAssociationInfo)this.model.getRowObject(selectedRow);
            if (info != null) {
                info.restoreDefaultAssociation();
                this.table.repaint();
            }
        });
        resetButton.setEnabled(false);
        this.table.setRowHeight(28);
        this.table.setColumnHeaderPopupEnabled(false);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(ContentHandler.class, (TableCellRenderer)((Object)new ContentHandlerRenderer()));
        this.table.setDefaultRenderer(GhidraToolTemplate.class, (TableCellRenderer)((Object)new ToolTemplateRenderer()));
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedRow = this.table.getSelectedRow();
            ToolAssociationInfo info = (ToolAssociationInfo)this.model.getRowObject(selectedRow);
            if (info == null) {
                editButton.setEnabled(false);
                resetButton.setEnabled(false);
                return;
            }
            editButton.setEnabled(true);
            resetButton.setEnabled(!info.isDefault());
        });
        this.loadList();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(editButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(resetButton);
        mainPanel.add((Component)new JScrollPane((Component)this.table), "Center");
        mainPanel.add((Component)buttonPanel, "South");
        return mainPanel;
    }

    private void loadList() {
        Project project = this.tool.getProject();
        ToolServices toolServices = project.getToolServices();
        Set<ToolAssociationInfo> infos = toolServices.getContentTypeToolAssociations();
        this.model.setData(new ArrayList<ToolAssociationInfo>(infos));
    }

    void showDialog() {
        this.clearStatusText();
        this.tool.showDialog(this);
    }

    protected void okCallback() {
        this.applyUserChoices();
        this.close();
    }

    private void applyUserChoices() {
        HashSet<ToolAssociationInfo> set = new HashSet<ToolAssociationInfo>(this.model.getModelData());
        this.tool.getToolServices().setContentTypeToolAssociations(set);
    }

    private class ToolTemplateRenderer
    extends GTableCellRenderer {
        private ToolTemplateRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            int row = data.getRowViewIndex();
            ToolTemplate template = (ToolTemplate)value;
            if (template == null) {
                this.renderDefaultTool(renderer, row);
                return renderer;
            }
            renderer.setIcon(template.getIcon());
            renderer.setText(template.getName());
            return renderer;
        }

        private void renderDefaultTool(JLabel renderer, int row) {
            ToolAssociationInfo info = (ToolAssociationInfo)SetToolAssociationsDialog.this.model.getRowObject(row);
            ToolTemplate template = info.getDefaultTemplate();
            if (template == null) {
                return;
            }
            renderer.setForeground(Color.LIGHT_GRAY);
            ImageIcon icon = null;
            icon = template.getName().equals(info.getAssociatedToolName()) ? ResourceManager.getDisabledIcon((ImageIcon)template.getIcon()) : ResourceManager.getDisabledIcon((ImageIcon)ResourceManager.getScaledIcon((Icon)ResourceManager.loadImage((String)"images/EmptyIcon.gif"), (int)24, (int)24));
            renderer.setText(info.getAssociatedToolName());
            renderer.setIcon(icon);
        }
    }

    private class ContentHandlerRenderer
    extends GTableCellRenderer {
        private ContentHandlerRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            ContentHandler handler = (ContentHandler)value;
            renderer.setIcon(handler.getIcon());
            renderer.setText(handler.getContentType());
            return renderer;
        }
    }

    private class ToolTemplateComparator
    implements Comparator<ToolAssociationInfo> {
        private ToolTemplateComparator() {
        }

        @Override
        public int compare(ToolAssociationInfo o1, ToolAssociationInfo o2) {
            return o1.getCurrentTemplate().getName().compareTo(o2.getCurrentTemplate().getName());
        }
    }

    private class ContentHandlerComparator
    implements Comparator<ToolAssociationInfo> {
        private ContentHandlerComparator() {
        }

        @Override
        public int compare(ToolAssociationInfo o1, ToolAssociationInfo o2) {
            return o1.getContentHandler().getContentType().compareTo(o2.getContentHandler().getContentType());
        }
    }

    private class ToolAssociationTableModel
    extends AbstractSortedTableModel<ToolAssociationInfo> {
        private List<ToolAssociationInfo> data;

        ToolAssociationTableModel() {
            super(0);
            this.data = Collections.emptyList();
        }

        void setData(List<ToolAssociationInfo> data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        public String getName() {
            return "Set Tool Association";
        }

        public Object getColumnValueForRow(ToolAssociationInfo t, int column) {
            switch (column) {
                case 0: {
                    return t.getContentHandler();
                }
                case 1: {
                    return t.getCurrentTemplate();
                }
            }
            return null;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Content Type";
                }
                case 1: {
                    return "Tool";
                }
            }
            return null;
        }

        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ContentHandler.class;
                }
                case 1: {
                    return GhidraToolTemplate.class;
                }
            }
            return null;
        }

        public List<ToolAssociationInfo> getModelData() {
            return this.data;
        }

        public boolean isSortable(int columnIndex) {
            return columnIndex == 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.data.size();
        }

        protected Comparator<ToolAssociationInfo> createSortComparator(int column) {
            switch (column) {
                case 0: {
                    return new ContentHandlerComparator();
                }
                case 1: {
                    return new ToolTemplateComparator();
                }
            }
            return super.createSortComparator(column);
        }
    }
}

