/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.ToolState;
import ghidra.framework.data.ToolStateFactory;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Transaction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.HashMap;

class DomainObjectDBTransaction
implements Transaction {
    private static int nextBaseId = 1234;
    private ArrayList<TransactionEntry> list;
    private HashMap<PluginTool, ToolState> toolStates;
    private int activeEntries = 0;
    private int status = 0;
    private boolean hasDBTransaction = false;
    private final long id;
    private WeakSet<AbortedTransactionListener> abortedTransactionListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private final int baseId;
    private final DomainObject domainObject;

    DomainObjectDBTransaction(long id, DomainObject domainObject) {
        this.domainObject = domainObject;
        this.id = id;
        this.baseId = DomainObjectDBTransaction.getNextBaseId();
        this.list = new ArrayList();
        this.toolStates = new HashMap();
        this.getToolStates();
    }

    private void getToolStates() {
        if (SystemUtilities.isInHeadlessMode()) {
            return;
        }
        for (Object consumer : this.domainObject.getConsumerList()) {
            if (!(consumer instanceof PluginTool)) continue;
            PluginTool tool = (PluginTool)consumer;
            try {
                ToolState toolState = ToolStateFactory.createToolState(tool, this.domainObject);
                this.toolStates.put(tool, toolState);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
            }
        }
    }

    void restoreToolStates(final boolean beforeState) {
        if (this.toolStates.isEmpty()) {
            return;
        }
        SystemUtilities.runSwingLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DomainObjectDBTransaction.this.domainObject.flushEvents();
                if (beforeState) {
                    DomainObjectDBTransaction.this.restoreToolStatesAfterUndo(DomainObjectDBTransaction.this.domainObject);
                } else {
                    DomainObjectDBTransaction.this.restoreToolStatesAfterRedo(DomainObjectDBTransaction.this.domainObject);
                }
            }
        });
    }

    static synchronized int getNextBaseId() {
        return nextBaseId++;
    }

    void setHasCommittedDBTransaction() {
        if (this.getStatus() != 1) {
            throw new IllegalStateException("transaction was not committed");
        }
        this.hasDBTransaction = true;
    }

    @Override
    public boolean hasCommittedDBTransaction() {
        return this.hasDBTransaction;
    }

    @Override
    public long getID() {
        return this.id;
    }

    int addEntry(String description, AbortedTransactionListener listener) {
        if (listener != null) {
            this.abortedTransactionListeners.add((Object)listener);
        }
        this.list.add(new TransactionEntry(description));
        ++this.activeEntries;
        DomainObjectDBTransaction.getNextBaseId();
        return this.list.size() + this.baseId - 1;
    }

    void endEntry(int transactionID, boolean commit) {
        TransactionEntry entry = null;
        try {
            entry = this.list.get(transactionID - this.baseId);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("Transaction not found");
        }
        if (entry.status != 0) {
            throw new IllegalStateException("Attempted to end Transaction more that once: " + entry.description);
        }
        int n = entry.status = commit ? 1 : 2;
        if (!commit) {
            this.status = 2;
        }
        if (--this.activeEntries == 0 && this.status == 0) {
            this.status = 1;
        }
    }

    @Override
    public int getStatus() {
        if (this.status == 2 && this.activeEntries > 0) {
            return 3;
        }
        return this.status;
    }

    private void restoreToolStatesAfterUndo(DomainObject object) {
        ArrayList<Object> consumers = object.getConsumerList();
        for (int i = 0; i < consumers.size(); ++i) {
            PluginTool tool;
            ToolState toolState;
            Object obj = consumers.get(i);
            if (!(obj instanceof PluginTool) || (toolState = this.toolStates.get(tool = (PluginTool)obj)) == null) continue;
            toolState.restoreAfterUndo(object);
        }
    }

    private void restoreToolStatesAfterRedo(DomainObject object) {
        ArrayList<Object> consumers = object.getConsumerList();
        for (int i = 0; i < consumers.size(); ++i) {
            PluginTool tool;
            ToolState toolState;
            Object obj = consumers.get(i);
            if (!(obj instanceof PluginTool) || (toolState = this.toolStates.get(tool = (PluginTool)obj)) == null) continue;
            toolState.restoreAfterRedo(object);
        }
    }

    @Override
    public String getDescription() {
        if (this.list.isEmpty()) {
            return "";
        }
        Object description = "";
        for (TransactionEntry entry : this.list) {
            description = entry.description;
            if (description == null || ((String)description).length() == 0) continue;
            description = this.domainObject.getDomainFile().getName() + ": " + (String)description;
            break;
        }
        return description;
    }

    @Override
    public ArrayList<String> getOpenSubTransactions() {
        ArrayList<String> subTxList = new ArrayList<String>();
        for (TransactionEntry entry : this.list) {
            if (entry.status != 0) continue;
            subTxList.add(entry.description);
        }
        return subTxList;
    }

    void initAfterState(DomainObject object) {
        ArrayList<Object> consumers = object.getConsumerList();
        for (int i = 0; i < consumers.size(); ++i) {
            PluginTool tool;
            ToolState toolState;
            Object obj = consumers.get(i);
            if (!(obj instanceof PluginTool) || (toolState = this.toolStates.get(tool = (PluginTool)obj)) == null) continue;
            toolState.getAfterState(object);
        }
    }

    void abort() {
        this.status = 2;
        for (AbortedTransactionListener listener : this.abortedTransactionListeners) {
            listener.transactionAborted(this.id);
        }
        this.abortedTransactionListeners.clear();
    }

    private static class TransactionEntry {
        String description;
        int status;

        TransactionEntry(String description) {
            this.description = description;
            this.status = 0;
        }
    }
}

