/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.help;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.dnd.GClipboard;
import docking.dnd.StringTransferable;
import docking.widgets.OptionDialog;
import docking.widgets.label.GIconLabel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class AboutDomainObjectUtils {
    private static final MouseListener COPY_MOUSE_LISTENER = new PopupMouseListener();

    public static void displayInformation(PluginTool tool, DomainFile domainFile, Map<String, String> metadata, String title, String additionalInfo, HelpLocation helpLocation) {
        JComponent aboutComp = AboutDomainObjectUtils.getAboutPanel(domainFile, metadata, additionalInfo);
        if (aboutComp == null) {
            return;
        }
        Dialog dialog = new Dialog(title, aboutComp);
        if (helpLocation != null) {
            dialog.setHelpLocation(helpLocation);
        }
        tool.showDialog(dialog);
    }

    private static void addInfo(JPanel panel, String name, String value) {
        if (value == null) {
            value = "?????";
        }
        JTextField nameField = new JTextField(name);
        nameField.setBorder(null);
        DockingUtils.setTransparent((JComponent)nameField);
        nameField.setEditable(false);
        nameField.addMouseListener(COPY_MOUSE_LISTENER);
        JTextField valueField = new JTextField(value);
        valueField.setBorder(null);
        DockingUtils.setTransparent((JComponent)valueField);
        valueField.setEditable(false);
        valueField.addMouseListener(COPY_MOUSE_LISTENER);
        panel.add(nameField);
        panel.add(valueField);
    }

    private static JComponent getAboutPanel(DomainFile domainFile, Map<String, String> metadata, String additionalInfo) {
        Component[] comps;
        Font font = new Font("Monospaced", 0, 12);
        JPanel aboutPanel = new JPanel((LayoutManager)new PairLayout());
        JScrollPane propertyScroll = new JScrollPane(aboutPanel);
        JPanel contentPanel = new JPanel(new BorderLayout(5, 5));
        contentPanel.add((Component)propertyScroll, "Center");
        AboutDomainObjectUtils.addInfo(aboutPanel, "Project File Name: ", domainFile.getName());
        long lastModified = domainFile.getLastModifiedTime();
        if (lastModified != 0L) {
            AboutDomainObjectUtils.addInfo(aboutPanel, "Last Modified:", new Date(lastModified).toString());
        }
        AboutDomainObjectUtils.addInfo(aboutPanel, "Readonly:", Boolean.toString(domainFile.isReadOnly()));
        for (String key : metadata.keySet()) {
            String value = metadata.get(key);
            AboutDomainObjectUtils.addInfo(aboutPanel, key + ":", value);
        }
        if (additionalInfo != null && additionalInfo.length() > 0) {
            JTextArea auxArea = new JTextArea(additionalInfo);
            auxArea.setFont(font);
            DockingUtils.setTransparent((JComponent)auxArea);
            auxArea.setEditable(false);
            auxArea.setCaretPosition(0);
            JScrollPane sp = new JScrollPane(auxArea);
            sp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Additional Information"));
            sp.setPreferredSize(new Dimension(1, 175));
            JScrollBar sb = sp.getVerticalScrollBar();
            sb.setBorder(BorderFactory.createEtchedBorder());
            contentPanel.add((Component)sp, "South");
        }
        JPanel infoPanel = new JPanel(new FlowLayout(0, 5, 10));
        infoPanel.add((Component)new GIconLabel(OptionDialog.getIconForMessageType((int)1)));
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)infoPanel, "West");
        panel.add((Component)contentPanel, "Center");
        for (Component comp : comps = aboutPanel.getComponents()) {
            comp.setFont(font);
        }
        aboutPanel.invalidate();
        panel.setPreferredSize(new Dimension(800, 800));
        return panel;
    }

    private static class PopupMouseListener
    extends MouseAdapter {
        private PopupMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.processPopupMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.processPopupMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.processPopupMouseEvent(e);
        }

        private void processPopupMouseEvent(MouseEvent e) {
            Component component = e.getComponent();
            if (component == null) {
                return;
            }
            Rectangle bounds = component.getBounds();
            if (component instanceof JComponent) {
                ((JComponent)component).computeVisibleRect(bounds);
            }
            Point point = e.getPoint();
            boolean withinBounds = bounds.contains(point);
            if (e.isPopupTrigger() && withinBounds) {
                JPopupMenu popupMenu = new JPopupMenu();
                JMenuItem item = new JMenuItem("Copy");
                item.addActionListener(event -> PopupMouseListener.writeDataToClipboard(component));
                popupMenu.add(item);
                popupMenu.show(component, e.getX(), e.getY());
            }
        }

        private static void writeDataToClipboard(Component component) {
            Clipboard systemClipboard = GClipboard.getSystemClipboard();
            try {
                systemClipboard.setContents(PopupMouseListener.createContents(component), null);
            }
            catch (IllegalStateException e) {
                Msg.showInfo(AboutDomainObjectUtils.class, null, (String)"Cannot Copy Data", (Object)"Unable to copy information to clipboard.  Please try again.");
            }
        }

        private static Transferable createContents(Component component) {
            Container parent = component.getParent();
            Component[] components = parent.getComponents();
            StringBuilder buffy = new StringBuilder();
            for (int i = 0; i < components.length; ++i) {
                buffy.append(((JTextComponent)components[i]).getText());
                if (i != 0 && i % 2 != 0) {
                    buffy.append('\n');
                    continue;
                }
                buffy.append('\t');
            }
            return new StringTransferable(buffy.toString());
        }
    }

    private static class Dialog
    extends DialogComponentProvider {
        Dialog(String title, JComponent workPanel) {
            super(title, false, false, true, false);
            this.init(workPanel);
        }

        private void init(JComponent workPanel) {
            this.addWorkPanel(workPanel);
            this.addOKButton();
            this.setRememberSize(true);
        }

        protected void okCallback() {
            this.close();
        }
    }
}

