/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.bitpatterns.gui.InputDialogComponentProvider;
import ghidra.closedpatternmining.SequenceMiningParams;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SequenceMiningParamsInputDialog
extends InputDialogComponentProvider {
    private JTextField percentageBox;
    private IntegerTextField minFixedBitsBox;
    private JRadioButton nibbleButton;
    private JRadioButton binaryButton;
    private ButtonGroup bGroup;
    private static final String PERCENTAGE_BOX_TEXT = "Minimum Support Percentage ";
    private static final String MIN_FIXED_BITS_BOX_TEXT = "Minimum Number of Fixed Bits ";
    private static final String BINARY_BUTTON_TEXT = "Binary Sequences";
    private static final String NIBBLE_BUTTON_TEXT = "Character Sequences";
    private static final String DEFAULT_PERCENTAGE = "10.0";
    private static final String DEFAULT_MIN_FIXED_BITS = "16";
    private static final char BINARY_MNEMONIC = 'B';
    private static final char NIBBLE_MNEMONIC = 'N';
    private static final String PERCENTAGE_PROPERTY = "SequenceMiningParamsCreator_percentage";
    private static final String MIN_FIXED_BITS_PROPERTY = "SequenceMiningParamsCreator_minbits";
    private static final String BINARY_SEQUENCES_PROPERTY = "SequenceMiningParamsCreator_binarySequences";
    private static final String BINARY_SEQUENCES_DEFAULT = Boolean.toString(false);

    public SequenceMiningParamsInputDialog(String title, Component parent) {
        super(title);
        JPanel panel = this.createPanel();
        this.addWorkPanel(panel);
        this.addOKButton();
        this.okButton.setText("OK");
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Mining_Closed_Sequential_Patterns");
        this.setHelpLocation(helpLocation);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    @Override
    protected JPanel createPanel() {
        JPanel mainPanel = new JPanel();
        PairLayout mainLayout = new PairLayout();
        mainPanel.setLayout((LayoutManager)mainLayout);
        mainPanel.add((Component)new GLabel(PERCENTAGE_BOX_TEXT));
        this.percentageBox = new JTextField(16);
        double percentage = Double.parseDouble(Preferences.getProperty((String)PERCENTAGE_PROPERTY, (String)DEFAULT_PERCENTAGE));
        this.percentageBox.setText(Double.toString(percentage));
        this.percentageBox.setEditable(true);
        mainPanel.add(this.percentageBox);
        mainPanel.add((Component)new GLabel(MIN_FIXED_BITS_BOX_TEXT));
        this.minFixedBitsBox = new IntegerTextField();
        int minFixBits = Integer.parseInt(Preferences.getProperty((String)MIN_FIXED_BITS_PROPERTY, (String)DEFAULT_MIN_FIXED_BITS));
        this.minFixedBitsBox.setValue(minFixBits);
        mainPanel.add(this.minFixedBitsBox.getComponent());
        boolean useBinary = Boolean.parseBoolean(Preferences.getProperty((String)BINARY_SEQUENCES_PROPERTY, (String)BINARY_SEQUENCES_DEFAULT));
        this.binaryButton = new GRadioButton(BINARY_BUTTON_TEXT, useBinary);
        this.binaryButton.setMnemonic('B');
        this.nibbleButton = new GRadioButton(NIBBLE_BUTTON_TEXT, !useBinary);
        this.nibbleButton.setMnemonic('N');
        mainPanel.add(this.binaryButton);
        mainPanel.add(this.nibbleButton);
        this.bGroup = new ButtonGroup();
        this.bGroup.add(this.binaryButton);
        this.bGroup.add(this.nibbleButton);
        return mainPanel;
    }

    public SequenceMiningParams getSequenceMiningParams() {
        int parsedMinFixedBits;
        double parsedPercentage;
        String percentageString = this.percentageBox.getText();
        try {
            parsedPercentage = Double.parseDouble(percentageString);
            Preferences.setProperty((String)PERCENTAGE_PROPERTY, (String)Double.toString(parsedPercentage));
        }
        catch (NumberFormatException e) {
            parsedPercentage = Double.parseDouble(DEFAULT_PERCENTAGE);
        }
        if (parsedPercentage <= 0.0 || parsedPercentage >= 100.0) {
            parsedPercentage = Double.parseDouble(DEFAULT_PERCENTAGE);
        }
        String minFixedBitsString = this.minFixedBitsBox.getText();
        try {
            parsedMinFixedBits = Integer.parseInt(minFixedBitsString);
            Preferences.setProperty((String)MIN_FIXED_BITS_PROPERTY, (String)Integer.toString(parsedMinFixedBits));
        }
        catch (NumberFormatException e) {
            parsedMinFixedBits = Integer.parseInt(DEFAULT_MIN_FIXED_BITS);
        }
        if (parsedMinFixedBits < 0) {
            parsedMinFixedBits = Integer.parseInt(DEFAULT_MIN_FIXED_BITS);
        }
        boolean useBinary = false;
        if (this.bGroup.getSelection().getMnemonic() == 66) {
            useBinary = true;
            Preferences.setProperty((String)BINARY_SEQUENCES_PROPERTY, (String)Boolean.toString(true));
        } else {
            Preferences.setProperty((String)BINARY_SEQUENCES_PROPERTY, (String)Boolean.toString(false));
        }
        Preferences.store();
        return new SequenceMiningParams(parsedPercentage / 100.0, parsedMinFixedBits, useBinary);
    }
}

