/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FGVertexType;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AbstractFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AbstractGraphComponentPanel;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupListener;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphComponentPanel;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGView;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes;
import ghidra.graph.viewer.GraphViewer;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class GroupedFunctionGraphVertex
extends AbstractFunctionGraphVertex {
    private GroupedFunctionGraphComponentPanel component;
    private final Set<FGVertex> vertices;
    private Set<FGEdge> ungroupedEdges;
    private Map<FGVertex, Point2D> preGroupingVertexLocations = new HashMap<FGVertex, Point2D>();
    private boolean doHashCode = true;
    private int hashCode;
    private GroupListener groupListener;
    private String initialGroupVertexUserText;

    private static AddressSetView gatherAddresses(Program program, Set<FGVertex> vertices) {
        if (vertices.size() == 0) {
            throw new IllegalArgumentException("Cannot create a group vertex with no grouped vertices");
        }
        AddressSet addresses = new AddressSet();
        for (FGVertex vertex : vertices) {
            addresses.add(vertex.getAddresses());
        }
        return addresses;
    }

    private static boolean isEntry(Set<FGVertex> vertices) {
        for (FGVertex vertex : vertices) {
            FGVertexType vertexType = vertex.getVertexType();
            if (vertexType != FGVertexType.ENTRY) continue;
            return true;
        }
        return false;
    }

    public GroupedFunctionGraphVertex(FGController controller, String groupVertexUserText, Set<FGVertex> vertices, Set<FGEdge> ungroupedEdges) {
        super(controller, controller.getProgram(), GroupedFunctionGraphVertex.gatherAddresses(controller.getProgram(), vertices), RefType.FALL_THROUGH, GroupedFunctionGraphVertex.isEntry(vertices));
        this.ungroupedEdges = this.convertGroupedEdgeEndpoints(ungroupedEdges);
        this.vertices = new HashSet<FGVertex>(vertices);
        this.initialGroupVertexUserText = groupVertexUserText;
        this.setVertexType(this.pickType());
        this.preGroupingVertexLocations = this.getCurrentVertexLocations();
    }

    private Set<FGEdge> convertGroupedEdgeEndpoints(Set<FGEdge> unvalidatedEdges) {
        HashSet<FGEdge> updatedEdges = new HashSet<FGEdge>(unvalidatedEdges.size());
        for (FGEdge edge : unvalidatedEdges) {
            this.convertGroupedEdge(edge, updatedEdges);
        }
        return updatedEdges;
    }

    private void convertGroupedEdge(FGEdge edge, Set<FGEdge> updatedEdges) {
        FGVertex destinationVertex;
        FGVertex startVertex = (FGVertex)edge.getStart();
        if (!this.eitherGroupedEndpoint(startVertex, destinationVertex = (FGVertex)edge.getEnd())) {
            updatedEdges.add(edge);
            return;
        }
        if (this.bothGroupedEndpoints(startVertex, destinationVertex)) {
            Set<FGEdge> intersectingConvertedEdges = this.getIntersectingEdges((GroupedFunctionGraphVertex)startVertex, (GroupedFunctionGraphVertex)destinationVertex);
            updatedEdges.addAll(intersectingConvertedEdges);
            return;
        }
        if (startVertex instanceof GroupedFunctionGraphVertex) {
            Set<FGEdge> convertedDestinationEdges = ((GroupedFunctionGraphVertex)startVertex).getAllEdgesWithDestination(destinationVertex);
            updatedEdges.addAll(convertedDestinationEdges);
        } else {
            Set<FGEdge> convertedStartEdges = ((GroupedFunctionGraphVertex)destinationVertex).getAllEdgesWithStart(startVertex);
            updatedEdges.addAll(convertedStartEdges);
        }
    }

    private Set<FGEdge> getIntersectingEdges(GroupedFunctionGraphVertex startGroup, GroupedFunctionGraphVertex destinationGroup) {
        Set<FGEdge> startGroupEdges = startGroup.getUngroupedEdges();
        Set<FGEdge> destinationGroupEdges = destinationGroup.getUngroupedEdges();
        HashSet<FGEdge> intersectingEdges = new HashSet<FGEdge>();
        intersectingEdges.addAll(startGroupEdges);
        intersectingEdges.retainAll(destinationGroupEdges);
        return intersectingEdges;
    }

    private Set<FGEdge> getAllEdgesWithDestination(FGVertex destinationVertex) {
        HashSet<FGEdge> matchingEdges = new HashSet<FGEdge>(this.ungroupedEdges.size());
        for (FGEdge edge : this.ungroupedEdges) {
            if (!((FGVertex)edge.getEnd()).equals(destinationVertex)) continue;
            matchingEdges.add(edge);
        }
        return matchingEdges;
    }

    private Set<FGEdge> getAllEdgesWithStart(FGVertex startVertex) {
        HashSet<FGEdge> matchingEdges = new HashSet<FGEdge>(this.ungroupedEdges.size());
        for (FGEdge edge : this.ungroupedEdges) {
            if (!((FGVertex)edge.getStart()).equals(startVertex)) continue;
            matchingEdges.add(edge);
        }
        return matchingEdges;
    }

    private boolean bothGroupedEndpoints(FGVertex startVertex, FGVertex destinationVertex) {
        return startVertex instanceof GroupedFunctionGraphVertex && destinationVertex instanceof GroupedFunctionGraphVertex;
    }

    private boolean eitherGroupedEndpoint(FGVertex startVertex, FGVertex destinationVertex) {
        return startVertex instanceof GroupedFunctionGraphVertex || destinationVertex instanceof GroupedFunctionGraphVertex;
    }

    public GroupedFunctionGraphVertex derriveGroupVertex(Set<FGVertex> additionalGroupedVertices, String groupVertexText, Set<FGEdge> additionalUngroupedEdges) {
        HashSet<FGEdge> newEdges = new HashSet<FGEdge>(this.ungroupedEdges);
        newEdges.addAll(additionalUngroupedEdges);
        HashSet<FGVertex> newVertices = new HashSet<FGVertex>(this.vertices);
        newVertices.addAll(additionalGroupedVertices);
        GroupedFunctionGraphVertex newVertex = new GroupedFunctionGraphVertex(this.getController(), groupVertexText, newVertices, newEdges);
        return newVertex;
    }

    public GroupedFunctionGraphVertex removeAll(Set<FGVertex> verticesToRemove) {
        HashSet<FGEdge> newEdges = new HashSet<FGEdge>(this.ungroupedEdges);
        for (FGVertex vertex : verticesToRemove) {
            this.removeIncidentEdges(vertex, newEdges);
        }
        HashSet<FGVertex> newVertices = new HashSet<FGVertex>(this.vertices);
        newVertices.removeAll(verticesToRemove);
        if (newVertices.isEmpty()) {
            return null;
        }
        GroupedFunctionGraphVertex newVertex = new GroupedFunctionGraphVertex(this.getController(), this.getUserText(), newVertices, newEdges);
        return newVertex;
    }

    private void removeIncidentEdges(FGVertex vertex, Set<FGEdge> newEdges) {
        for (FGEdge edge : this.ungroupedEdges) {
            if (!vertex.equals(edge.getStart()) && !vertex.equals(edge.getEnd())) continue;
            newEdges.remove(edge);
        }
    }

    private Map<FGVertex, Point2D> getCurrentVertexLocations() {
        FGController fgController = this.getController();
        FGView view = fgController.getView();
        GraphViewer viewer = view.getPrimaryGraphViewer();
        Layout graphLayout = viewer.getGraphLayout();
        Graph graph = graphLayout.getGraph();
        Collection currentVertices = graph.getVertices();
        HashMap<FGVertex, Point2D> map = new HashMap<FGVertex, Point2D>();
        for (FGVertex vertex : currentVertices) {
            if (vertex == this) continue;
            Point2D point2D = (Point2D)graphLayout.apply((Object)vertex);
            map.put(vertex, new Point((int)point2D.getX(), (int)point2D.getY()));
        }
        return map;
    }

    private FGVertexType pickType() {
        boolean hasEntry = false;
        boolean hasExit = false;
        for (FGVertex vertex : this.vertices) {
            FGVertexType vertexType = vertex.getVertexType();
            if (vertexType == FGVertexType.ENTRY) {
                hasEntry = true;
                continue;
            }
            if (vertexType != FGVertexType.EXIT) continue;
            hasExit = true;
        }
        if (hasEntry) {
            return FGVertexType.ENTRY;
        }
        if (hasExit) {
            return FGVertexType.EXIT;
        }
        return FGVertexType.GROUP;
    }

    @Override
    public void writeSettings(FunctionGraphVertexAttributes settings) {
        for (FGVertex vertex : this.vertices) {
            vertex.writeSettings(settings);
        }
    }

    @Override
    public void readSettings(FunctionGraphVertexAttributes settings) {
        for (FGVertex vertex : this.vertices) {
            vertex.readSettings(settings);
        }
    }

    @Override
    public FGVertex cloneVertex(FGController newController) {
        throw new UnsupportedOperationException("cloneVertex() unsupported--not needed");
    }

    @Override
    boolean hasLoadedComponent() {
        return this.component != null;
    }

    @Override
    AbstractGraphComponentPanel doGetComponent() {
        if (this.component == null) {
            SystemUtilities.assertThisIsTheSwingThread((String)"Cannot create vertex component off of the Swing thread");
            this.component = new GroupedFunctionGraphComponentPanel(this.getController(), this, this.initialGroupVertexUserText);
            if (this.pendingRestoreColor != null) {
                this.component.restoreColor(this.pendingRestoreColor);
                this.pendingRestoreColor = null;
            }
        }
        return this.component;
    }

    @Override
    public void dispose() {
        this.groupListener = null;
        for (FGVertex vertex : this.vertices) {
            vertex.dispose();
        }
        this.vertices.clear();
        super.dispose();
    }

    public String getUserText() {
        return ((GroupedFunctionGraphComponentPanel)this.doGetComponent()).getUserText();
    }

    void userTextChanged(String oldText, String text) {
        this.groupListener.groupDescriptionChanged(oldText, text);
    }

    public void addGroupListener(GroupListener listener) {
        if (this.groupListener != null) {
            throw new AssertException("Update code to handle multiple listeners!");
        }
        this.groupListener = listener;
    }

    public void removeGroupListener(GroupListener listener) {
        if (this.groupListener != null && this.groupListener != listener) {
            throw new AssertException("Update code to handle multiple listeners!");
        }
        this.groupListener = null;
    }

    public Set<FGVertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices);
    }

    public Set<FGEdge> getUngroupedEdges() {
        return Collections.unmodifiableSet(this.ungroupedEdges);
    }

    public Map<FGVertex, Point2D> getPreGroupLocations() {
        return Collections.unmodifiableMap(this.preGroupingVertexLocations);
    }

    public static String generateGroupVertexDescription(Set<FGVertex> vertices) {
        ArrayList<FGVertex> sortedList = new ArrayList<FGVertex>(vertices);
        Collections.sort(sortedList, (v1, v2) -> {
            Address a1 = v1.getVertexAddress();
            Address a2 = v2.getVertexAddress();
            return a1.compareTo((Object)a2);
        });
        StringBuilder buffy = new StringBuilder();
        for (FGVertex subVertex : sortedList) {
            if (subVertex instanceof GroupedFunctionGraphVertex) {
                buffy.append("Group Vertex").append('\n');
                String text = ((GroupedFunctionGraphVertex)subVertex).getUserText();
                StringTokenizer tokenizzy = new StringTokenizer(text, "\n");
                while (tokenizzy.hasMoreTokens()) {
                    buffy.append('\t').append(tokenizzy.nextToken()).append('\n');
                }
            } else {
                buffy.append(GroupedFunctionGraphVertex.getVertexDescription(subVertex));
            }
            buffy.append('\n');
        }
        return buffy.toString();
    }

    public static String getVertexDescription(FGVertex vertex) {
        return "Vertex: " + vertex.getTitle();
    }

    @Override
    public int hashCode() {
        if (this.doHashCode) {
            this.hashCode = this.vertices.hashCode();
            this.doHashCode = false;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupedFunctionGraphVertex other = (GroupedFunctionGraphVertex)obj;
        Set<FGVertex> otherVertices = other.getVertices();
        return this.vertices.equals(otherVertices);
    }
}

