/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangOpToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.hover.AbstractHoverProvider;
import ghidra.app.services.HoverService;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.ProgramLocation;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class DecompilerHoverProvider
extends AbstractHoverProvider {
    public DecompilerHoverProvider() {
        super("DecompilerHoverProvider");
    }

    public void addHoverService(DecompilerHoverService hoverService) {
        super.addHoverService((HoverService)hoverService);
    }

    public void removeHoverService(DecompilerHoverService hoverService) {
        super.removeHoverService((HoverService)hoverService);
    }

    protected ProgramLocation getHoverLocation(FieldLocation fieldLocation, Field field, Rectangle fieldBounds, MouseEvent event) {
        HighVariable highVar;
        if (!(field instanceof ClangTextField)) {
            return null;
        }
        ClangTextField decompilerField = (ClangTextField)field;
        ClangToken token = decompilerField.getToken(fieldLocation);
        if (token instanceof ClangOpToken) {
            return null;
        }
        if (token instanceof ClangTypeToken) {
            ClangTypeToken typeToken = (ClangTypeToken)token;
            HighVariable hv = typeToken.getHighVariable();
            if (hv == null) {
                return null;
            }
            Address localAddr = hv.getRepresentative().getAddress();
            return new ProgramLocation(this.program, localAddr);
        }
        if (token.getMinAddress() == null) {
            return null;
        }
        Address reference = null;
        Varnode vn = token.getVarnode();
        if (vn != null && (highVar = vn.getHigh()) instanceof HighGlobal) {
            reference = highVar.getRepresentative().getAddress();
        }
        return new ProgramLocation(this.program, token.getMinAddress(), reference);
    }
}

