/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompileResults;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.Objects;

public class DecompilerLocation
extends ProgramLocation {
    private Address functionEntryPoint;
    private DecompileResults results;
    private ClangToken token;
    private String tokenName;
    private int lineNumber;
    private int charPos;

    public DecompilerLocation(Program program, Address address, Address functionEntryPoint, DecompileResults results, ClangToken token, int lineNumber, int charPos) {
        super(program, address);
        this.functionEntryPoint = functionEntryPoint;
        this.results = results;
        this.token = token;
        this.tokenName = token.getText();
        this.lineNumber = lineNumber;
        this.charPos = charPos;
    }

    public DecompilerLocation() {
    }

    public Address getFunctionEntryPoint() {
        return this.functionEntryPoint;
    }

    public DecompileResults getDecompile() {
        return this.results;
    }

    public ClangToken getToken() {
        return this.token;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.charPos;
        result = 31 * result + (this.functionEntryPoint == null ? 0 : this.functionEntryPoint.hashCode());
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DecompilerLocation other = (DecompilerLocation)((Object)obj);
        if (this.charPos != other.charPos) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        if (!Objects.equals(this.functionEntryPoint, other.functionEntryPoint)) {
            return false;
        }
        return Objects.equals(this.tokenName, other.tokenName);
    }

    public void saveState(SaveState saveState) {
        super.saveState(saveState);
        saveState.putString("_FUNCTION_ENTRY", this.functionEntryPoint.toString());
        saveState.putString("_TOKEN_TEXT", this.tokenName);
        saveState.putInt("_LINE_NUM", this.lineNumber);
        saveState.putInt("_CHAR_POS", this.charPos);
    }

    public void restoreState(Program program1, SaveState obj) {
        super.restoreState(program1, obj);
        String addrStr = obj.getString("_FUNCTION_ENTRY", "0");
        this.functionEntryPoint = program1.parseAddress(addrStr)[0];
        this.tokenName = obj.getString("_TOKEN_TEXT", "");
        this.lineNumber = obj.getInt("_LINE_NUM", 0);
        this.charPos = obj.getInt("_CHAR_POS", 0);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharPos() {
        return this.charPos;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(((Object)((Object)this)).getClass().getSimpleName());
        buf.append('@');
        buf.append(this.addr.toString());
        buf.append(", line=");
        buf.append(this.lineNumber);
        buf.append(", character=");
        buf.append(this.charPos);
        buf.append(", token=");
        buf.append(this.tokenName);
        return buf.toString();
    }
}

