/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.combobox.GComboBox;
import docking.widgets.list.GListCellRenderer;
import docking.widgets.table.constraint.BooleanMatchColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;

public class BooleanConstraintEditor
extends AbstractColumnConstraintEditor<Boolean> {
    private JComboBox<Boolean> comboBox;

    public BooleanConstraintEditor(BooleanMatchColumnConstraint constraint) {
        super(constraint);
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.comboBox = new GComboBox<Boolean>(new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        this.comboBox.setRenderer(GListCellRenderer.createDefaultCellTextRenderer(b -> StringUtils.capitalize((String)b.toString())));
        this.comboBox.addItemListener(e -> this.valueChanged());
        panel.add(this.comboBox, "Center");
        return panel;
    }

    @Override
    protected ColumnConstraint<Boolean> getValueFromComponent() {
        Boolean b = (Boolean)this.comboBox.getSelectedItem();
        return new BooleanMatchColumnConstraint(b);
    }

    @Override
    protected void updateEditorComponent() {
        if (this.hasEditorComponents()) {
            this.comboBox.setSelectedItem(this.getConstraint().getValue());
        }
    }

    @Override
    public void reset() {
        this.comboBox.setSelectedIndex(0);
    }

    @Override
    protected boolean checkEditorValueValidity() {
        return true;
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
    }

    @Override
    public String getErrorMessage() {
        return "";
    }

    private BooleanMatchColumnConstraint getConstraint() {
        return (BooleanMatchColumnConstraint)this.currentConstraint;
    }

    JComboBox<Boolean> getComboBox() {
        return this.comboBox;
    }
}

