/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.symbol.OldVariableStorageDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

public class OldVariableStorageDBAdapterV0
extends OldVariableStorageDBAdapter {
    private static final int TABLE_VERSION = 0;
    private Table variableStorageTable;

    OldVariableStorageDBAdapterV0(DBHandle handle) throws VersionException {
        this.variableStorageTable = handle.getTable("VariableStorage");
        if (this.variableStorageTable == null || this.variableStorageTable.getSchema().getVersion() != 0) {
            throw new VersionException();
        }
    }

    @Override
    long getNextStorageID() {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteRecord(long key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Record getRecord(long key) throws IOException {
        return this.variableStorageTable.getRecord(key);
    }

    @Override
    Record[] getRecordsForNamespace(long namespaceID) throws IOException {
        long[] keys = this.variableStorageTable.findRecords((Field)new LongField(namespaceID), 1);
        Record[] records = new Record[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            records[i] = this.variableStorageTable.getRecord(keys[i]);
        }
        return records;
    }

    @Override
    void updateRecord(Record record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.variableStorageTable.iterator();
    }

    @Override
    int getRecordCount() {
        return this.variableStorageTable.getRecordCount();
    }
}

