/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.ByteField;
import db.DBBuffer;
import db.DBHandle;
import db.IntField;
import db.LongField;
import db.Record;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.BitMappedSubMemoryBlock;
import ghidra.program.database.mem.BufferSubMemoryBlock;
import ghidra.program.database.mem.ByteMappedSubMemoryBlock;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.FileBytesSubMemoryBlock;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.database.mem.UninitializedSubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MemoryMapDBAdapterV3
extends MemoryMapDBAdapter {
    public static final int V3_VERSION = 3;
    public static final String TABLE_NAME = "Memory Blocks";
    public static final String SUB_BLOCK_TABLE_NAME = "Sub Memory Blocks";
    public static final int V3_NAME_COL = 0;
    public static final int V3_COMMENTS_COL = 1;
    public static final int V3_SOURCE_COL = 2;
    public static final int V3_PERMISSIONS_COL = 3;
    public static final int V3_START_ADDR_COL = 4;
    public static final int V3_LENGTH_COL = 5;
    public static final int V3_SEGMENT_COL = 6;
    public static final int V3_SUB_PARENT_ID_COL = 0;
    public static final int V3_SUB_TYPE_COL = 1;
    public static final int V3_SUB_LENGTH_COL = 2;
    public static final int V3_SUB_START_OFFSET_COL = 3;
    public static final int V3_SUB_SOURCE_ID_COL = 4;
    public static final int V3_SUB_SOURCE_OFFSET_COL = 5;
    public static final byte V3_SUB_TYPE_BIT_MAPPED = 0;
    public static final byte V3_SUB_TYPE_BYTE_MAPPED = 1;
    public static final byte V3_SUB_TYPE_BUFFER = 2;
    public static final byte V3_SUB_TYPE_UNITIALIZED = 3;
    public static final byte V3_SUB_TYPE_FILE_BYTES = 4;
    static Schema V3_BLOCK_SCHEMA = new Schema(3, "Key", new Class[]{StringField.class, StringField.class, StringField.class, ByteField.class, LongField.class, LongField.class, IntField.class}, new String[]{"Name", "Comments", "Source Name", "Permissions", "Start Address", "Length", "Segment"});
    static Schema V3_SUB_BLOCK_SCHEMA = new Schema(3, "Key", new Class[]{LongField.class, ByteField.class, LongField.class, LongField.class, IntField.class, LongField.class}, new String[]{"Parent ID", "Type", "Length", "Starting Offset", "Source ID", "Source Address/Offset"});
    private DBHandle handle;
    private Table memBlockTable;
    private Table subBlockTable;
    private MemoryMapDB memMap;
    private AddressMapDB addrMap;
    private List<MemoryBlockDB> memoryBlocks = new ArrayList<MemoryBlockDB>();
    private long maxSubBlockSize;

    public MemoryMapDBAdapterV3(DBHandle handle, MemoryMapDB memMap, long maxSubBlockSize, boolean create) throws VersionException, IOException {
        this.handle = handle;
        this.memMap = memMap;
        this.maxSubBlockSize = maxSubBlockSize;
        this.addrMap = memMap.getAddressMap();
        if (create) {
            this.memBlockTable = handle.createTable(TABLE_NAME, V3_BLOCK_SCHEMA);
            this.subBlockTable = handle.createTable(SUB_BLOCK_TABLE_NAME, V3_SUB_BLOCK_SCHEMA);
        } else {
            this.memBlockTable = handle.getTable(TABLE_NAME);
            this.subBlockTable = handle.getTable(SUB_BLOCK_TABLE_NAME);
            if (this.memBlockTable == null) {
                throw new VersionException(handle.getTable("Memory Block") != null);
            }
            if (this.subBlockTable == null || this.memBlockTable.getSchema().getVersion() != 3) {
                int version = this.memBlockTable.getSchema().getVersion();
                throw new VersionException(version < 3);
            }
        }
    }

    @Override
    void deleteTable(DBHandle dbHandle) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void refreshMemory() throws IOException {
        Map<Long, List<SubMemoryBlock>> subBlockMap = this.getSubBlockMap();
        Map blockMap = this.memoryBlocks.stream().collect(Collectors.toMap(MemoryBlockDB::getID, Function.identity()));
        ArrayList<MemoryBlockDB> newBlocks = new ArrayList<MemoryBlockDB>();
        for (Record record : this.memBlockTable) {
            long key = record.getKey();
            MemoryBlockDB block = (MemoryBlockDB)blockMap.remove(key);
            if (block != null) {
                block.refresh(record, subBlockMap.get(key));
            } else {
                block = new MemoryBlockDB(this, record, subBlockMap.get(key));
            }
            newBlocks.add(block);
        }
        for (MemoryBlockDB block : blockMap.values()) {
            block.invalidate();
        }
        Collections.sort(newBlocks);
        this.memoryBlocks = newBlocks;
    }

    @Override
    List<MemoryBlockDB> getMemoryBlocks() {
        return this.memoryBlocks;
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, InputStream is, long length, int permissions) throws AddressOverflowException, IOException {
        this.updateAddressMapForAllAddresses(startAddr, length);
        ArrayList<SubMemoryBlock> subBlocks = new ArrayList<SubMemoryBlock>();
        try {
            Record blockRecord = this.createMemoryBlockRecord(name, startAddr, length, permissions);
            long key = blockRecord.getKey();
            int numFullBlocks = (int)(length / this.maxSubBlockSize);
            int lastSubBlockSize = (int)(length % this.maxSubBlockSize);
            long blockOffset = 0L;
            for (int i = 0; i < numFullBlocks; ++i) {
                subBlocks.add(this.createBufferSubBlock(key, blockOffset, this.maxSubBlockSize, is));
                blockOffset += this.maxSubBlockSize;
            }
            if (lastSubBlockSize > 0) {
                subBlocks.add(this.createBufferSubBlock(key, blockOffset, lastSubBlockSize, is));
            }
            this.memBlockTable.putRecord(blockRecord);
            MemoryBlockDB newBlock = new MemoryBlockDB(this, blockRecord, subBlocks);
            this.memoryBlocks.add(newBlock);
            Collections.sort(this.memoryBlocks);
            return newBlock;
        }
        catch (IOCancelledException e) {
            for (SubMemoryBlock subMemoryBlock : subBlocks) {
                BufferSubMemoryBlock bufferSubMemoryBlock = (BufferSubMemoryBlock)subMemoryBlock;
                this.subBlockTable.deleteRecord(bufferSubMemoryBlock.getKey());
                bufferSubMemoryBlock.buf.delete();
            }
            throw e;
        }
    }

    @Override
    MemoryBlockDB createBlock(MemoryBlockType blockType, String name, Address startAddr, long length, Address mappedAddress, boolean initializeBytes, int permissions) throws AddressOverflowException, IOException {
        if (initializeBytes) {
            return this.createInitializedBlock(name, startAddr, null, length, permissions);
        }
        if (blockType == MemoryBlockType.BIT_MAPPED) {
            return this.createBitMappedBlock(name, startAddr, length, mappedAddress, permissions);
        }
        if (blockType == MemoryBlockType.BYTE_MAPPED) {
            return this.createByteMappedBlock(name, startAddr, length, mappedAddress, permissions);
        }
        return this.createUnitializedBlock(name, startAddr, length, permissions);
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, DBBuffer buf, int permissions) throws AddressOverflowException, IOException {
        this.updateAddressMapForAllAddresses(startAddr, buf.length());
        ArrayList<SubMemoryBlock> subBlocks = new ArrayList<SubMemoryBlock>();
        Record blockRecord = this.createMemoryBlockRecord(name, startAddr, buf.length(), permissions);
        long key = blockRecord.getKey();
        Record subRecord = this.createSubBlockRecord(key, 0L, buf.length(), (byte)2, buf.getId(), 0L);
        this.subBlockTable.putRecord(subRecord);
        subBlocks.add(new BufferSubMemoryBlock(this, subRecord));
        this.memBlockTable.putRecord(blockRecord);
        MemoryBlockDB newBlock = new MemoryBlockDB(this, blockRecord, subBlocks);
        this.memoryBlocks.add(newBlock);
        Collections.sort(this.memoryBlocks);
        return newBlock;
    }

    MemoryBlockDB createUnitializedBlock(String name, Address startAddress, long length, int permissions) throws IOException, AddressOverflowException {
        this.updateAddressMapForAllAddresses(startAddress, length);
        ArrayList<SubMemoryBlock> subBlocks = new ArrayList<SubMemoryBlock>();
        Record blockRecord = this.createMemoryBlockRecord(name, startAddress, length, permissions);
        long key = blockRecord.getKey();
        Record subRecord = this.createSubBlockRecord(key, 0L, length, (byte)3, 0, 0L);
        subBlocks.add(new UninitializedSubMemoryBlock(this, subRecord));
        this.memBlockTable.putRecord(blockRecord);
        MemoryBlockDB newBlock = new MemoryBlockDB(this, blockRecord, subBlocks);
        this.memoryBlocks.add(newBlock);
        Collections.sort(this.memoryBlocks);
        return newBlock;
    }

    @Override
    protected MemoryBlockDB createBlock(String name, Address startAddress, long length, int permissions, List<SubMemoryBlock> splitBlocks) throws IOException {
        Record blockRecord = this.createMemoryBlockRecord(name, startAddress, length, permissions);
        long key = blockRecord.getKey();
        long startingOffset = 0L;
        for (SubMemoryBlock subMemoryBlock : splitBlocks) {
            subMemoryBlock.setParentIdAndStartingOffset(key, startingOffset);
            startingOffset += subMemoryBlock.subBlockLength;
        }
        this.memBlockTable.putRecord(blockRecord);
        MemoryBlockDB newBlock = new MemoryBlockDB(this, blockRecord, splitBlocks);
        int insertionIndex = Collections.binarySearch(this.memoryBlocks, newBlock);
        if (insertionIndex >= 0) {
            throw new AssertException("New memory block collides with existing block");
        }
        this.memoryBlocks.add(-insertionIndex - 1, newBlock);
        return newBlock;
    }

    MemoryBlockDB createBitMappedBlock(String name, Address startAddress, long length, Address mappedAddress, int permissions) throws IOException, AddressOverflowException {
        return this.createMappedBlock((byte)0, name, startAddress, length, mappedAddress, permissions);
    }

    MemoryBlockDB createByteMappedBlock(String name, Address startAddress, long length, Address mappedAddress, int permissions) throws IOException, AddressOverflowException {
        return this.createMappedBlock((byte)1, name, startAddress, length, mappedAddress, permissions);
    }

    @Override
    protected MemoryBlockDB createFileBytesBlock(String name, Address startAddress, long length, FileBytes fileBytes, long offset, int permissions) throws IOException, AddressOverflowException {
        this.updateAddressMapForAllAddresses(startAddress, length);
        ArrayList<SubMemoryBlock> subBlocks = new ArrayList<SubMemoryBlock>();
        Record blockRecord = this.createMemoryBlockRecord(name, startAddress, length, permissions);
        long key = blockRecord.getKey();
        Record subRecord = this.createSubBlockRecord(key, 0L, length, (byte)4, (int)fileBytes.getId(), offset);
        subBlocks.add(this.createSubBlock(subRecord));
        this.memBlockTable.putRecord(blockRecord);
        MemoryBlockDB newBlock = new MemoryBlockDB(this, blockRecord, subBlocks);
        this.memoryBlocks.add(newBlock);
        Collections.sort(this.memoryBlocks);
        return newBlock;
    }

    private MemoryBlockDB createMappedBlock(byte type, String name, Address startAddress, long length, Address mappedAddress, int permissions) throws IOException, AddressOverflowException {
        this.updateAddressMapForAllAddresses(startAddress, length);
        ArrayList<SubMemoryBlock> subBlocks = new ArrayList<SubMemoryBlock>();
        Record blockRecord = this.createMemoryBlockRecord(name, startAddress, length, permissions);
        long key = blockRecord.getKey();
        long encoded = this.addrMap.getKey(mappedAddress, true);
        Record subRecord = this.createSubBlockRecord(key, 0L, length, type, 0, encoded);
        subBlocks.add(this.createSubBlock(subRecord));
        this.memBlockTable.putRecord(blockRecord);
        MemoryBlockDB newBlock = new MemoryBlockDB(this, blockRecord, subBlocks);
        this.memoryBlocks.add(newBlock);
        Collections.sort(this.memoryBlocks);
        return newBlock;
    }

    @Override
    void deleteMemoryBlock(long key) throws IOException {
        this.memBlockTable.deleteRecord(key);
    }

    @Override
    void deleteSubBlock(long key) throws IOException {
        this.subBlockTable.deleteRecord(key);
    }

    @Override
    void updateBlockRecord(Record record) throws IOException {
        this.memBlockTable.putRecord(record);
    }

    @Override
    protected void updateSubBlockRecord(Record record) throws IOException {
        this.subBlockTable.putRecord(record);
    }

    @Override
    DBBuffer getBuffer(int bufferID) throws IOException {
        if (bufferID >= 0) {
            return this.handle.getBuffer(bufferID);
        }
        return null;
    }

    @Override
    MemoryMapDB getMemoryMap() {
        return this.memMap;
    }

    @Override
    Record createSubBlockRecord(long parentKey, long startingOffset, long length, byte type, int sourceId, long sourceOffset) throws IOException {
        Record record = V3_SUB_BLOCK_SCHEMA.createRecord(this.subBlockTable.getKey());
        record.setLongValue(0, parentKey);
        record.setByteValue(1, type);
        record.setLongValue(2, length);
        record.setLongValue(3, startingOffset);
        record.setIntValue(4, sourceId);
        record.setLongValue(5, sourceOffset);
        this.subBlockTable.putRecord(record);
        return record;
    }

    private Record createMemoryBlockRecord(String name, Address startAddr, long length, int permissions) {
        Record record = V3_BLOCK_SCHEMA.createRecord(this.memBlockTable.getKey());
        record.setString(0, name);
        record.setLongValue(4, this.addrMap.getKey(startAddr, true));
        record.setLongValue(5, length);
        record.setByteValue(3, (byte)permissions);
        record.setIntValue(6, this.getSegment(startAddr));
        return record;
    }

    private Map<Long, List<SubMemoryBlock>> getSubBlockMap() throws IOException {
        ArrayList<SubMemoryBlock> subBlocks = new ArrayList<SubMemoryBlock>(this.subBlockTable.getRecordCount());
        for (Record record : this.subBlockTable) {
            subBlocks.add(this.createSubBlock(record));
        }
        return subBlocks.stream().collect(Collectors.groupingBy(SubMemoryBlock::getParentBlockID));
    }

    private int getSegment(Address addr) {
        if (addr instanceof SegmentedAddress) {
            return ((SegmentedAddress)addr).getSegment();
        }
        return 0;
    }

    private void updateAddressMapForAllAddresses(Address startAddress, long length) throws AddressOverflowException {
        AddressSet set = new AddressSet(startAddress, startAddress.addNoWrap(length - 1L));
        this.addrMap.getKeyRanges(set, true);
    }

    private SubMemoryBlock createSubBlock(Record record) throws IOException {
        byte byteValue = record.getByteValue(1);
        switch (byteValue) {
            case 0: {
                return new BitMappedSubMemoryBlock(this, record);
            }
            case 1: {
                return new ByteMappedSubMemoryBlock(this, record);
            }
            case 2: {
                return new BufferSubMemoryBlock(this, record);
            }
            case 3: {
                return new UninitializedSubMemoryBlock(this, record);
            }
            case 4: {
                return new FileBytesSubMemoryBlock(this, record);
            }
        }
        throw new AssertException("Unhandled sub block type: " + byteValue);
    }

    private SubMemoryBlock createBufferSubBlock(long parentKey, long offset, long length, InputStream is) throws IOException {
        DBBuffer buffer = this.createBuffer(length, is);
        Record record = this.createSubBlockRecord(parentKey, offset, length, (byte)2, buffer.getId(), 0L);
        return new BufferSubMemoryBlock(this, record);
    }

    private DBBuffer createBuffer(long length, InputStream is) throws IOException {
        DBBuffer buf = this.handle.createBuffer((int)length);
        if (is != null) {
            try {
                buf.fill(is);
            }
            catch (IOCancelledException e) {
                buf.delete();
                throw e;
            }
        }
        return buf;
    }

    @Override
    DBBuffer createBuffer(int length, byte initialValue) throws IOException {
        DBBuffer buffer = this.handle.createBuffer(length);
        buffer.fill(0, length - 1, initialValue);
        return buffer;
    }
}

