/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import ghidra.program.database.code.CodeManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import java.util.Iterator;

class CodeUnitRecordIterator
implements CodeUnitIterator {
    private CodeManager codeMgr;
    private InstructionIterator instIt;
    private DataIterator dataIt;
    private AddressIterator addrIt;
    private boolean forward;
    private Address nextAddr;
    private Instruction nextInst;
    private Data nextData;
    private CodeUnit nextCu;

    CodeUnitRecordIterator(CodeManager codeMgr, InstructionIterator instIt, DataIterator dataIt, AddressSetView set, boolean forward) {
        this.codeMgr = codeMgr;
        this.instIt = instIt;
        this.dataIt = dataIt;
        this.forward = forward;
        this.addrIt = set.getAddresses(forward);
        this.nextAddr = this.addrIt.next();
        this.nextData = dataIt.next();
        this.nextInst = instIt.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.nextCu == null) {
            this.findNext();
        }
        return this.nextCu != null;
    }

    @Override
    public CodeUnit next() {
        if (this.hasNext()) {
            CodeUnit ret = this.nextCu;
            this.nextCu = null;
            return ret;
        }
        return null;
    }

    private void findNext() {
        while (this.nextAddr != null && this.nextCu == null) {
            CodeUnit nextDefined = null;
            if (this.nextInst == null) {
                nextDefined = this.nextData;
            } else if (this.nextData == null) {
                nextDefined = this.nextInst;
            } else {
                int c = this.nextInst.getMinAddress().compareTo(this.nextData.getMinAddress());
                c = this.forward ? c : -c;
                CodeUnit codeUnit = nextDefined = c < 0 ? this.nextInst : this.nextData;
            }
            if (nextDefined != null && !nextDefined.contains(this.nextAddr)) {
                nextDefined = null;
            }
            if (nextDefined != null) {
                if (nextDefined == this.nextInst) {
                    this.nextInst = this.instIt.next();
                } else {
                    this.nextData = this.dataIt.next();
                }
            } else {
                nextDefined = this.codeMgr.getUndefinedAt(this.nextAddr);
            }
            this.nextAddr = this.getNextAddr(this.nextAddr, nextDefined);
            this.nextCu = nextDefined;
        }
    }

    private Address getNextAddr(Address addr, CodeUnit cu) {
        if (cu == null) {
            return this.addrIt.next();
        }
        if (this.forward) {
            Address end = cu.getMaxAddress();
            while (addr != null && addr.compareTo(end) <= 0) {
                addr = this.addrIt.next();
            }
        } else {
            Address start = cu.getMinAddress();
            while (addr != null && addr.compareTo(start) >= 0) {
                addr = this.addrIt.next();
            }
        }
        return addr;
    }

    @Override
    public Iterator<CodeUnit> iterator() {
        return this;
    }
}

