/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class IntField
extends Field {
    private int value;

    public IntField() {
    }

    public IntField(int i) {
        this.value = i;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public void setIntValue(int value) {
        this.value = value;
    }

    @Override
    int length() {
        return 4;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putInt(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.value = buf.getInt(offset);
        return offset + 4;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 4;
    }

    @Override
    protected byte getFieldType() {
        return 2;
    }

    public String toString() {
        return "IntField: " + Integer.toString(this.value);
    }

    @Override
    public String getValueAsString() {
        return Integer.toHexString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IntField)) {
            return false;
        }
        return ((IntField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        IntField f = (IntField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public Field newField(Field fieldValue) {
        if (fieldValue.isVariableLength()) {
            throw new AssertException();
        }
        return new IntField((int)fieldValue.getLongValue());
    }

    @Override
    public Field newField() {
        return new IntField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.value = (int)value;
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{(byte)(this.value >> 24), (byte)(this.value >> 16), (byte)(this.value >> 8), (byte)this.value};
    }

    @Override
    public int hashCode() {
        return this.value;
    }
}

