/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBLongIterator;
import db.Field;
import db.FieldIndexTable;
import db.FixedIndexTable;
import db.IndexBuffer;
import db.IndexField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Table;
import db.TableRecord;
import db.TableStatistics;
import db.VarIndexTable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.NoSuchElementException;

abstract class IndexTable {
    protected static final long[] emptyKeyArray = new long[0];
    protected final DBHandle db;
    protected final TableRecord indexTableRecord;
    protected Table primaryTable;
    protected Table indexTable;
    protected final Field fieldType;
    protected final int colIndex;

    IndexTable(Table primaryTable, TableRecord indexTableRecord) throws IOException {
        if (!primaryTable.useLongKeys()) {
            throw new AssertException("Only long-key tables may be indexed");
        }
        this.db = primaryTable.getDBHandle();
        this.primaryTable = primaryTable;
        this.indexTableRecord = indexTableRecord;
        this.indexTable = new Table(primaryTable.getDBHandle(), indexTableRecord);
        this.colIndex = indexTableRecord.getIndexedColumn();
        this.fieldType = primaryTable.getSchema().getField(indexTableRecord.getIndexedColumn());
        primaryTable.addIndex(this);
    }

    static IndexTable getIndexTable(DBHandle db, TableRecord indexTableRecord) throws IOException {
        String name = indexTableRecord.getName();
        Table primaryTable = db.getTable(name);
        if (primaryTable == null) {
            throw new AssertException("Table not found: " + name);
        }
        if (indexTableRecord.getSchema().getKeyFieldType() instanceof IndexField) {
            return new FieldIndexTable(primaryTable, indexTableRecord);
        }
        Field fieldType = primaryTable.getSchema().getField(indexTableRecord.getIndexedColumn());
        if (fieldType.isVariableLength()) {
            return new VarIndexTable(primaryTable, indexTableRecord);
        }
        return new FixedIndexTable(primaryTable, indexTableRecord);
    }

    static IndexTable createIndexTable(Table primaryTable, int indexColumn) throws IOException {
        if (primaryTable.getRecordCount() != 0) {
            throw new AssertException();
        }
        return new FieldIndexTable(primaryTable, indexColumn);
    }

    boolean isConsistent(TaskMonitor monitor) throws IOException, CancelledException {
        return this.indexTable.isConsistent(this.primaryTable.getSchema().getFieldNames()[this.colIndex], monitor);
    }

    long getTableNum() {
        return this.indexTable.getTableNum();
    }

    int getColumnIndex() {
        return this.colIndex;
    }

    TableStatistics getStatistics() throws IOException {
        TableStatistics stats = this.indexTable.getStatistics();
        stats.indexColumn = this.colIndex;
        return stats;
    }

    boolean hasRecord(Field field) throws IOException {
        return this.indexTable.hasRecord(field);
    }

    abstract long[] findPrimaryKeys(Field var1) throws IOException;

    abstract int getKeyCount(Field var1) throws IOException;

    abstract void addEntry(Record var1) throws IOException;

    abstract void deleteEntry(Record var1) throws IOException;

    void deleteAll() throws IOException {
        this.indexTable.deleteAll();
    }

    abstract DBFieldIterator indexIterator() throws IOException;

    abstract DBFieldIterator indexIterator(Field var1, Field var2, boolean var3) throws IOException;

    abstract DBFieldIterator indexIterator(Field var1, Field var2, Field var3, boolean var4) throws IOException;

    DBLongIterator keyIterator() throws IOException {
        return new PrimaryKeyIterator();
    }

    DBLongIterator keyIteratorBefore(Field startField) throws IOException {
        return new PrimaryKeyIterator(startField, false);
    }

    DBLongIterator keyIteratorAfter(Field startField) throws IOException {
        return new PrimaryKeyIterator(startField, true);
    }

    DBLongIterator keyIteratorBefore(Field startField, long primaryKey) throws IOException {
        return new PrimaryKeyIterator(null, null, startField, primaryKey, false);
    }

    DBLongIterator keyIteratorAfter(Field startField, long primaryKey) throws IOException {
        return new PrimaryKeyIterator(null, null, startField, primaryKey, true);
    }

    DBLongIterator keyIterator(Field minField, Field maxField, boolean before) throws IOException {
        Field startField;
        Field field = startField = before ? minField : maxField;
        if (startField != null || !before) {
            // empty if block
        }
        return new PrimaryKeyIterator(minField, maxField, before ? minField : maxField, before ? Long.MIN_VALUE : Long.MAX_VALUE, !before);
    }

    DBLongIterator keyIterator(Field minField, Field maxField, Field startField, boolean before) throws IOException {
        return new PrimaryKeyIterator(minField, maxField, startField, before ? Long.MIN_VALUE : Long.MAX_VALUE, !before);
    }

    private class PrimaryKeyIterator
    implements DBLongIterator {
        private RecordIterator indexIterator;
        private int expectedModCount;
        private int index;
        private long indexPrimaryKey;
        private IndexBuffer indexBuffer;
        private boolean forward = true;
        private boolean reverse = true;
        private Field lastKey;
        private boolean hasPrev = false;
        private boolean hasNext = false;

        PrimaryKeyIterator() throws IOException {
            this.expectedModCount = IndexTable.this.indexTable.modCount;
            this.indexIterator = IndexTable.this.indexTable.iterator();
        }

        PrimaryKeyIterator(Field startValue, boolean after) throws IOException {
            this(null, null, startValue, after ? Long.MAX_VALUE : Long.MIN_VALUE, after);
        }

        PrimaryKeyIterator(Field minValue, Field maxValue, Field startValue, long primaryKey, boolean after) throws IOException {
            this.expectedModCount = IndexTable.this.indexTable.modCount;
            this.indexIterator = IndexTable.this.indexTable.iterator(minValue, maxValue, startValue);
            if (this.hasNext() && startValue.equals(this.indexBuffer.getIndexKey())) {
                this.index = this.indexBuffer.getIndex(primaryKey);
                if (this.index < 0) {
                    this.index = -this.index - 1;
                } else if (after) {
                    ++this.index;
                }
                if (this.index == this.indexBuffer.keyCount) {
                    --this.index;
                    this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                    this.hasNext = false;
                    this.hasPrev = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return true;
            }
            DBHandle dBHandle = IndexTable.this.db;
            synchronized (dBHandle) {
                if (this.indexBuffer != null && this.index < this.indexBuffer.keyCount - 1 && IndexTable.this.indexTable.modCount != this.expectedModCount) {
                    Field indexKey = this.indexBuffer.getIndexKey();
                    Record indexRecord = indexKey.isVariableLength() ? IndexTable.this.indexTable.getRecord(indexKey) : IndexTable.this.indexTable.getRecord(indexKey.getLongValue());
                    if (indexRecord != null) {
                        this.indexBuffer = new IndexBuffer(indexKey, indexRecord.getBinaryData(0));
                        this.index = this.indexBuffer.getIndex(this.indexPrimaryKey + 1L);
                        if (this.index < 0) {
                            this.index = -this.index - 1;
                            if (this.index == this.indexBuffer.keyCount) {
                                this.indexBuffer = null;
                            } else {
                                this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                                this.hasNext = true;
                            }
                        } else {
                            this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                            this.hasNext = true;
                        }
                    } else {
                        this.indexBuffer = null;
                    }
                    this.hasPrev = false;
                }
                if (!this.hasNext) {
                    if (this.indexBuffer == null || this.index >= this.indexBuffer.keyCount - 1) {
                        Record indexRecord = this.indexIterator.next();
                        if (indexRecord != null) {
                            if (!this.forward) {
                                indexRecord = this.indexIterator.next();
                                this.forward = true;
                            }
                            this.reverse = false;
                            if (indexRecord != null) {
                                this.indexBuffer = new IndexBuffer(IndexTable.this.fieldType.newField(indexRecord.getKeyField()), indexRecord.getBinaryData(0));
                                this.index = 0;
                                this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                                this.hasNext = true;
                                this.hasPrev = false;
                            }
                        }
                    } else {
                        ++this.index;
                        this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                        this.hasNext = true;
                        this.hasPrev = false;
                    }
                }
                this.expectedModCount = IndexTable.this.indexTable.modCount;
                return this.hasNext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() throws IOException {
            if (this.hasPrev) {
                return true;
            }
            DBHandle dBHandle = IndexTable.this.db;
            synchronized (dBHandle) {
                if (this.indexBuffer != null && this.index > 0 && IndexTable.this.indexTable.modCount != this.expectedModCount) {
                    Field indexKey = this.indexBuffer.getIndexKey();
                    Record indexRecord = indexKey.isVariableLength() ? IndexTable.this.indexTable.getRecord(indexKey) : IndexTable.this.indexTable.getRecord(indexKey.getLongValue());
                    if (indexRecord != null) {
                        this.indexBuffer = new IndexBuffer(indexKey, indexRecord.getBinaryData(0));
                        this.index = this.indexBuffer.getIndex(this.indexPrimaryKey - 1L);
                        if (this.index < 0) {
                            this.index = -this.index - 1;
                            if (this.index == 0) {
                                this.indexBuffer = null;
                            } else {
                                --this.index;
                                this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                                this.hasPrev = true;
                            }
                        } else {
                            this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                            this.hasPrev = true;
                        }
                    } else {
                        this.indexBuffer = null;
                    }
                    this.hasNext = false;
                }
                if (!this.hasPrev) {
                    if (this.indexBuffer == null || this.index == 0) {
                        Record indexRecord = this.indexIterator.previous();
                        if (indexRecord != null) {
                            if (!this.reverse) {
                                indexRecord = this.indexIterator.previous();
                                this.reverse = true;
                            }
                            this.forward = false;
                            if (indexRecord != null) {
                                this.indexBuffer = new IndexBuffer(IndexTable.this.fieldType.newField(indexRecord.getKeyField()), indexRecord.getBinaryData(0));
                                this.index = this.indexBuffer.keyCount - 1;
                                this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                                this.hasNext = false;
                                this.hasPrev = true;
                            }
                        }
                    } else {
                        --this.index;
                        this.indexPrimaryKey = this.indexBuffer.getPrimaryKey(this.index);
                        this.hasNext = false;
                        this.hasPrev = true;
                    }
                }
                this.expectedModCount = IndexTable.this.indexTable.modCount;
                return this.hasPrev;
            }
        }

        @Override
        public long next() throws IOException {
            if (this.hasNext || this.hasNext()) {
                long key = this.indexBuffer.getPrimaryKey(this.index);
                this.lastKey = new LongField(key);
                this.hasNext = false;
                this.hasPrev = true;
                return key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public long previous() throws IOException {
            if (this.hasPrev || this.hasPrevious()) {
                long key = this.indexBuffer.getPrimaryKey(this.index);
                this.lastKey = new LongField(key);
                this.hasNext = true;
                this.hasPrev = false;
                return key;
            }
            throw new NoSuchElementException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean delete() throws IOException {
            if (this.lastKey == null) {
                return false;
            }
            DBHandle dBHandle = IndexTable.this.db;
            synchronized (dBHandle) {
                long key = this.lastKey.getLongValue();
                IndexTable.this.primaryTable.deleteRecord(key);
                this.lastKey = null;
                return true;
            }
        }
    }
}

