/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test;

import generic.test.AbstractGenericTest;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.project.test.TestProjectManager;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ProjectTestUtils {
    private static Set<String> ignoredDeleteNames = new HashSet<String>(Arrays.asList("application.log"));

    public static Project getProject(String directory, String name) throws IOException, LockException {
        ProjectManager pm = TestProjectManager.get();
        ProjectLocator url = new ProjectLocator(directory, name);
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            throw new AssertException("Test directory does not exist: " + dir);
        }
        File projDir = url.getProjectDir();
        if (projDir.exists()) {
            try {
                return pm.openProject(url, true, false);
            }
            catch (NotFoundException e) {
                throw new RuntimeException("Bad project directory: " + projDir);
            }
            catch (NotOwnerException e) {
                // empty catch block
            }
        }
        try {
            return pm.createProject(url, null, true);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Bad project name: " + name);
        }
    }

    public static boolean deleteProject(String directory, String name) {
        ProjectLocator locator = new ProjectLocator(directory, name);
        File lockFile = locator.getProjectLockFile();
        if (!ProjectTestUtils.deleteLockFile(lockFile)) {
            throw new AssertException("Project is in use and can't be deleted: " + locator.getProjectDir());
        }
        File projectDir = locator.getProjectDir();
        boolean success = ProjectTestUtils.deleteDir(locator.getProjectDir());
        if (!success && projectDir.exists()) {
            return false;
        }
        locator.getMarkerFile().delete();
        return true;
    }

    private static boolean deleteLockFile(File lockFile) {
        File secondLockFile;
        if (!lockFile.exists()) {
            return true;
        }
        boolean deleted = lockFile.delete();
        if (!deleted) {
            Msg.warn(ProjectTestUtils.class, (Object)("deleteLockFile(): unable to delete file " + lockFile.getAbsolutePath() + "- trying again."));
            for (int i = 0; i < 6; ++i) {
                AbstractGenericTest.waitForPostedSwingRunnables();
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            deleted = lockFile.delete();
        }
        if ((secondLockFile = new File(lockFile.getAbsolutePath() + "~")).exists()) {
            deleted = secondLockFile.delete();
        }
        return deleted;
    }

    private static boolean deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return dir.delete();
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                if (ProjectTestUtils.deleteDir(files[i])) continue;
                Msg.debug(ProjectTestUtils.class, (Object)("Unable to delete directory: " + files[i]));
                return false;
            }
            if (files[i].delete() || ignoredDeleteNames.contains(files[i].getName())) continue;
            Msg.debug(ProjectTestUtils.class, (Object)("Unable to delete file: " + files[i]));
            return false;
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DomainFile createProgramFile(Project proj, String progName, Language language, CompilerSpec compilerSpec, DomainFolder folder) throws InvalidNameException, CancelledException, LanguageNotFoundException, IOException {
        if (folder == null) {
            folder = proj.getProjectData().getRootFolder();
        }
        Object consumer = new Object();
        ProgramDB p = new ProgramDB(progName, language, compilerSpec, consumer);
        try {
            DomainFile domainFile = folder.createFile(progName, (DomainObject)p, null);
            return domainFile;
        }
        finally {
            p.release(consumer);
        }
    }

    public static Tool getTool(Project project, String toolName) {
        ToolManager tm = project.getToolManager();
        Workspace[] workspaces = tm.getWorkspaces();
        Workspace activeWorkspace = workspaces[0];
        Tool tool = null;
        if (toolName == null) {
            tool = activeWorkspace.createTool();
        } else {
            ToolChest toolChest = project.getLocalToolChest();
            ToolTemplate toolTemplate = toolChest.getToolTemplate(toolName);
            tool = activeWorkspace.runTool(toolTemplate);
        }
        return tool;
    }

    public static ToolTemplate saveTool(Project project, Tool tool) {
        ToolChest toolChest = project.getLocalToolChest();
        ToolTemplate toolTemplate = tool.saveToolToToolTemplate();
        toolChest.addToolTemplate(toolTemplate);
        return toolTemplate;
    }

    public static boolean deleteTool(Project project, String toolName) {
        ToolChest toolChest = project.getLocalToolChest();
        return toolChest.remove(toolName);
    }
}

