/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;

public class FSRLRoot
extends FSRL {
    private final int hashCode = super.hashCode();

    public static FSRLRoot makeRoot(String protocol) {
        return new FSRLRoot(null, protocol);
    }

    public static FSRLRoot nestedFS(FSRL containerFile, String fstype) {
        if (containerFile instanceof FSRLRoot) {
            throw new RuntimeException("Can't make nestedFS with FSRLRoot path: " + containerFile);
        }
        return new FSRLRoot(containerFile, fstype);
    }

    public static FSRLRoot nestedFS(FSRL containerFile, FSRLRoot copyFSRL) {
        if (containerFile instanceof FSRLRoot) {
            throw new RuntimeException("Can't make nestedFS with FSRLRoot path: " + containerFile);
        }
        return new FSRLRoot(containerFile, copyFSRL.getProtocol());
    }

    private FSRLRoot(FSRL parent, String protocol) {
        super(parent, protocol);
    }

    @Override
    public FSRLRoot getFS() {
        return this;
    }

    public String getProtocol() {
        return this.path;
    }

    public FSRL getContainer() {
        return this.parent;
    }

    public boolean hasContainer() {
        return this.parent != null;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    public FSRL withPathMD5(String newPath, String newMD5) {
        return new FSRL(this, newPath, newMD5);
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb, boolean recurse, boolean includeParams, boolean includeFSRoot) {
        if (this.parent != null && recurse) {
            this.parent.appendToStringBuilder(sb, recurse, includeParams, includeFSRoot);
            sb.append("|");
        }
        if (includeFSRoot) {
            sb.append(this.path).append("://");
        }
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

