/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.field.VerticalLayoutTextField;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldUtils;
import docking.widgets.fieldpanel.support.HighlightFactory;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FieldHighlightFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class PlateFieldFactory
extends FieldFactory {
    private static final String EMPTY_STRING = "";
    public static final String FIELD_NAME = "Plate Comment";
    public static final Color DEFAULT_COLOR = Color.BLUE;
    private static final String FIELD_GROUP_TITLE = "Plate Comments Field";
    public static final String ENABLE_WORD_WRAP_MSG = "Plate Comments Field.Enable Word Wrapping";
    private static final int CONTENT_PADDING = 4;
    private static final String ELLIPSIS = "...";
    static final String FUNCTION_PLATE_COMMENT = " FUNCTION";
    static final String THUNK_FUNCTION_PLATE_COMMENT = " THUNK FUNCTION";
    static final String POINTER_TO_EXTERNAL_FUNCTION_COMMENT = " POINTER to EXTERNAL FUNCTION";
    static final String POINTER_TO_NONEXTERNAL_FUNCTION_COMMENT = " POINTER to FUNCTION";
    static final String CASE_PLATE_COMMENT = " CASE";
    static final String EXT_ENTRY_PLATE_COMMENT = " EXTERNAL ENTRY";
    static final String DEAD_CODE_PLATE_COMMENT = " DEAD";
    static final String SUBROUTINE_PLATE_COMMENT = " SUBROUTINE";
    static final String DEFAULT_PLATE_COMMENT = "  ";
    static final String GROUP_TITLE = "Format Code";
    static final String SHOW_SUBROUTINE_PLATES_OPTION = "Format Code.  Show Subroutine Plates";
    static final String SHOW_FUNCTION_PLATES_OPTION = "Format Code.  Show Function Plates";
    static final String SHOW_TRANSITION_PLATES_OPTION = "Format Code.  Show Transition Plates";
    static final String SHOW_EXT_ENTRY_PLATES_OPTION = "Format Code.  Show External Entry Plates";
    static final String LINES_BEFORE_FUNCTIONS_OPTION = "Format Code.Lines Before Functions";
    static final String LINES_BEFORE_LABELS_OPTION = "Format Code.Lines Before Labels";
    static final String LINES_BEFORE_PLATES_OPTION = "Format Code.Lines Before Plates";
    private boolean initialized;
    private String stars = "";
    private boolean showFunctionPlates;
    private boolean showSubroutinePlates;
    private boolean showTransitionPlates;
    private boolean showExternalPlates;
    private boolean showExternalFunctionPointerPlates;
    private boolean showNonExternalFunctionPointerPlates;
    private int nLinesBeforeFunctions;
    private int nLinesBeforeLabels;
    private int nLinesBeforePlates;
    private boolean isWordWrap;

    public PlateFieldFactory() {
        super(FIELD_NAME);
    }

    private PlateFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.init(fieldOptions);
        this.isWordWrap = fieldOptions.getBoolean(ENABLE_WORD_WRAP_MSG, false);
        this.showExternalPlates = fieldOptions.getBoolean(SHOW_EXT_ENTRY_PLATES_OPTION, false);
        this.showFunctionPlates = fieldOptions.getBoolean(SHOW_FUNCTION_PLATES_OPTION, true);
        this.showSubroutinePlates = fieldOptions.getBoolean(SHOW_SUBROUTINE_PLATES_OPTION, true);
        this.showTransitionPlates = fieldOptions.getBoolean(SHOW_TRANSITION_PLATES_OPTION, false);
        this.nLinesBeforeFunctions = fieldOptions.getInt(LINES_BEFORE_FUNCTIONS_OPTION, 0);
        this.nLinesBeforeLabels = fieldOptions.getInt(LINES_BEFORE_LABELS_OPTION, 1);
        this.nLinesBeforePlates = fieldOptions.getInt(LINES_BEFORE_PLATES_OPTION, 0);
        this.showExternalFunctionPointerPlates = fieldOptions.getBoolean("Function Pointers.Display External Function Pointer Header", true);
        this.showNonExternalFunctionPointerPlates = fieldOptions.getBoolean("Function Pointers.Display Non-External Function Pointer Header", false);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        CodeUnit cu = (CodeUnit)proxy.getObject();
        ArrayList<FieldElement> elementList = new ArrayList<FieldElement>(10);
        boolean isClipped = false;
        String commentText = this.getCommentText(cu);
        if (commentText == null || commentText.isEmpty()) {
            this.generateDefaultPlate(elementList, cu);
        } else {
            isClipped = this.generateFormattedPlateComment(elementList, cu);
        }
        this.addBlankLines(elementList, cu);
        if (elementList.size() == 0) {
            return null;
        }
        FieldElement[] fields = new FieldElement[elementList.size()];
        elementList.toArray(fields);
        PlateFieldTextField textField = new PlateFieldTextField(fields, this, proxy, this.startX, this.width, commentText, isClipped);
        return new PlateListingTextField(proxy, textField);
    }

    private String getCommentText(CodeUnit cu) {
        String[] comments = cu.getCommentAsArray(3);
        if (comments == null) {
            return null;
        }
        StringBuilder buffy = new StringBuilder();
        for (String comment : comments) {
            if (buffy.length() != 0) {
                buffy.append('\n');
            }
            buffy.append(comment);
        }
        return buffy.toString();
    }

    private boolean generateFormattedPlateComment(List<FieldElement> elementList, CodeUnit cu) {
        String[] comments = cu.getCommentAsArray(3);
        if (comments == null || comments.length == 0) {
            return false;
        }
        Program program = cu.getProgram();
        AttributedString prototype = new AttributedString(EMPTY_STRING, this.color, this.getMetrics());
        for (int i = 0; i < comments.length; ++i) {
            elementList.add((FieldElement)CommentUtils.parseTextForAnnotations(comments[i], program, prototype, i));
        }
        if (this.isWordWrap) {
            elementList = FieldUtils.wordWrapList((FieldElement)new CompositeFieldElement(elementList), (int)this.width);
        }
        return this.addBorder(elementList);
    }

    private void addBlankLines(List<FieldElement> elementList, CodeUnit cu) {
        AttributedString prototype = new AttributedString(EMPTY_STRING, this.color, this.getMetrics());
        TextFieldElement blankLine = new TextFieldElement(prototype, 0, 0);
        int numBlankLines = this.getNumberBlankLines(cu, elementList.size() > 0);
        for (int i = 0; i < numBlankLines; ++i) {
            elementList.add(0, (FieldElement)blankLine);
        }
    }

    private int getNumberBlankLines(CodeUnit cu, boolean hasPlate) {
        if (cu.getProgram().getListing().getFunctionAt(cu.getMinAddress()) != null && this.nLinesBeforeFunctions != 0) {
            return this.nLinesBeforeFunctions;
        }
        if (hasPlate && this.nLinesBeforePlates != 0) {
            return this.nLinesBeforePlates;
        }
        if (cu.getLabel() != null) {
            return this.nLinesBeforeLabels;
        }
        return 0;
    }

    private boolean addBorder(List<FieldElement> elements) {
        AttributedString asteriscs = this.getStarsString();
        boolean isClipped = this.addSideBorders(elements);
        elements.add(0, (FieldElement)new TextFieldElement(asteriscs, 0, 0));
        elements.add((FieldElement)new TextFieldElement(asteriscs, elements.size(), 0));
        return isClipped;
    }

    private boolean addSideBorders(List<FieldElement> elements) {
        FieldElement element;
        boolean isClipped = false;
        if (elements.size() == 1 && (element = elements.get(0)).length() > 1 && element.charAt(0) == ' ') {
            FieldElementResult result = this.addSideBorder(element.substring(1), 1, true);
            isClipped = result.isClipped();
            elements.set(0, result.getFieldElement());
            return isClipped;
        }
        for (int i = 0; i < elements.size(); ++i) {
            FieldElementResult result = this.addSideBorder(elements.get(i), i + 1, false);
            isClipped |= result.isClipped();
            elements.set(i, result.getFieldElement());
        }
        return isClipped;
    }

    private FieldElementResult addSideBorder(FieldElement element, int row, boolean center) {
        int ellipsisLength = 0;
        int availableWidth = this.stars.length() - 4;
        String ellipsisText = EMPTY_STRING;
        if (element.length() > availableWidth) {
            ellipsisText = ELLIPSIS;
            ellipsisLength = ELLIPSIS.length();
            availableWidth = this.stars.length() - 4 - ellipsisLength;
            element = element.substring(0, availableWidth);
        }
        int charWidth = this.getMetrics().charWidth(' ');
        int paddingWidth = (4 + ellipsisLength) * charWidth;
        int textWidth = paddingWidth + element.getStringWidth();
        int totalPadding = (this.width - textWidth) / charWidth;
        int prePadding = center ? totalPadding / 2 : 0;
        int postPadding = center ? (totalPadding + 1) / 2 : totalPadding;
        StringBuffer buffy = new StringBuffer();
        buffy.append('*').append(' ');
        this.addPadding(buffy, prePadding);
        TextFieldElement prefix = new TextFieldElement(new AttributedString(buffy.toString(), this.color, this.getMetrics()), row, 0);
        TextFieldElement ellipsis = new TextFieldElement(new AttributedString(ellipsisText, this.color, this.getMetrics()), row, prefix.length() + element.length());
        buffy.setLength(0);
        this.addPadding(buffy, postPadding);
        buffy.append(' ').append('*');
        TextFieldElement suffix = new TextFieldElement(new AttributedString(buffy.toString(), this.color, this.getMetrics()), row, prefix.length() + element.length() + ellipsis.length());
        return new FieldElementResult((FieldElement)new CompositeFieldElement(new FieldElement[]{prefix, element, ellipsis, suffix}), ellipsisLength > 0);
    }

    private void addPadding(StringBuffer buf, int count) {
        for (int i = 0; i < count; ++i) {
            buf.append(' ');
        }
    }

    private void generateDefaultPlate(List<FieldElement> elementList, CodeUnit cu) {
        String defaultComment = this.getDefaultComment(cu);
        if (defaultComment != null) {
            AttributedString as = new AttributedString(defaultComment, this.color, this.getMetrics());
            elementList.add((FieldElement)new TextFieldElement(as, 0, 0));
            this.addBorder(elementList);
        }
    }

    private String getDefaultComment(CodeUnit cu) {
        Symbol s;
        Reference ref;
        Function function;
        if (this.showFunctionPlates && (function = cu.getProgram().getListing().getFunctionAt(cu.getMinAddress())) != null) {
            return function.isThunk() ? THUNK_FUNCTION_PLATE_COMMENT : FUNCTION_PLATE_COMMENT;
        }
        if (this.showExternalPlates && this.isExternalEntry(cu)) {
            return EXT_ENTRY_PLATE_COMMENT;
        }
        if (this.showSubroutinePlates && this.hasCallReferences(cu)) {
            return SUBROUTINE_PLATE_COMMENT;
        }
        if (this.showTransitionPlates) {
            if (this.isDeadCode(cu)) {
                return DEAD_CODE_PLATE_COMMENT;
            }
            if (this.isTransitionCode(cu)) {
                return DEFAULT_PLATE_COMMENT;
            }
        }
        if (this.showFunctionPlates && cu instanceof Data && ((Data)cu).isPointer() && (ref = cu.getPrimaryReference(0)) != null && (s = cu.getProgram().getSymbolTable().getPrimarySymbol(ref.getToAddress())) != null && s.getSymbolType() == SymbolType.FUNCTION) {
            if (this.showExternalFunctionPointerPlates && s.isExternal()) {
                return POINTER_TO_EXTERNAL_FUNCTION_COMMENT;
            }
            if (this.showNonExternalFunctionPointerPlates && !s.isExternal()) {
                return POINTER_TO_NONEXTERNAL_FUNCTION_COMMENT;
            }
        }
        return null;
    }

    private boolean isExternalEntry(CodeUnit cu) {
        return cu.getProgram().getSymbolTable().isExternalEntryPoint(cu.getMinAddress());
    }

    private boolean hasCallReferences(CodeUnit cu) {
        Program program = cu.getProgram();
        ReferenceIterator iter = program.getReferenceManager().getReferencesTo(cu.getMinAddress());
        int count = 0;
        while (iter.hasNext() && ++count < 10) {
            Reference ref = iter.next();
            RefType refType = ref.getReferenceType();
            if (refType != RefType.CONDITIONAL_CALL && refType != RefType.UNCONDITIONAL_CALL) continue;
            return true;
        }
        return false;
    }

    private AttributedString getStarsString() {
        String asteriscs = this.getStars();
        return new AttributedString(asteriscs, this.color, this.getMetrics());
    }

    private String getStars() {
        int starWidth = this.getMetrics().charWidth('*');
        int n = this.width / starWidth;
        if (this.stars.length() != n) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                buf.append('*');
            }
            this.stars = buf.toString();
        }
        return this.stars;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField listingField) {
        Object proxyObject = listingField.getProxy().getObject();
        if (proxyObject instanceof Function) {
            Function func = (Function)proxyObject;
            Listing listing = func.getProgram().getListing();
            proxyObject = listing.getCodeUnitAt(func.getEntryPoint());
        }
        if (!(proxyObject instanceof CodeUnit)) {
            return null;
        }
        int[] cpath = null;
        if (proxyObject instanceof Data) {
            cpath = ((Data)proxyObject).getComponentPath();
        }
        CodeUnit cu = (CodeUnit)proxyObject;
        String[] comments = cu.getCommentAsArray(3);
        RowColLocation dataLocation = ((ListingTextField)listingField).screenToDataLocation(row, col);
        int fillerLineCount = this.getNumberOfLeadingFillerLines(listingField);
        int commentRow = row - fillerLineCount;
        if (commentRow >= comments.length) {
            commentRow = -1;
        }
        return new PlateFieldLocation(cu.getProgram(), ((CodeUnit)proxyObject).getMinAddress(), cpath, dataLocation.row(), dataLocation.col(), comments, commentRow);
    }

    private int getNumberOfLeadingFillerLines(ListingField listingField) {
        if (!(listingField instanceof PlateListingTextField)) {
            return 0;
        }
        PlateFieldTextField plateField = ((PlateListingTextField)listingField).getPlateTextField();
        return plateField.getLeadingFillerLineCount();
    }

    @Override
    public FieldLocation getFieldLocation(ListingField listingField, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof CommentFieldLocation)) {
            return null;
        }
        CommentFieldLocation commentLocation = (CommentFieldLocation)programLoc;
        if (commentLocation.getCommentType() != 3) {
            return null;
        }
        Object obj = listingField.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        ListingTextField listingTextField = (ListingTextField)listingField;
        RowColLocation location = listingTextField.dataToScreenLocation(commentLocation.getRow(), commentLocation.getCharOffset());
        return new FieldLocation(index, fieldNum, location.row(), location.col());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 1;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider hsProvider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new PlateFieldFactory(formatModel, hsProvider, (Options)toolOptions, (Options)fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.COMMENT_PLATE.getDefaultColor();
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(SHOW_EXT_ENTRY_PLATES_OPTION)) {
            this.showExternalPlates = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(SHOW_FUNCTION_PLATES_OPTION)) {
            this.showFunctionPlates = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(SHOW_SUBROUTINE_PLATES_OPTION)) {
            this.showSubroutinePlates = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(SHOW_TRANSITION_PLATES_OPTION)) {
            this.showTransitionPlates = (Boolean)newValue;
            this.model.update();
        } else if (optionName.equals(LINES_BEFORE_FUNCTIONS_OPTION)) {
            this.nLinesBeforeFunctions = (Integer)newValue;
            if (this.nLinesBeforeFunctions < 0) {
                this.nLinesBeforeFunctions = 0;
            }
            this.model.update();
        } else if (optionName.equals(LINES_BEFORE_LABELS_OPTION)) {
            this.nLinesBeforeLabels = (Integer)newValue;
            if (this.nLinesBeforeLabels < 0) {
                this.nLinesBeforeLabels = 0;
            }
            this.model.update();
        } else if (optionName.equals(LINES_BEFORE_PLATES_OPTION)) {
            this.nLinesBeforePlates = (Integer)newValue;
            if (this.nLinesBeforePlates < 0) {
                this.nLinesBeforePlates = 0;
            }
            this.model.update();
        } else if (optionName.equals(ENABLE_WORD_WRAP_MSG)) {
            this.isWordWrap = (Boolean)newValue;
        } else if (optionName.equals("Function Pointers.Display External Function Pointer Header")) {
            this.showExternalFunctionPointerPlates = (Boolean)newValue;
        } else if (optionName.equals("Function Pointers.Display Non-External Function Pointer Header")) {
            this.showNonExternalFunctionPointerPlates = (Boolean)newValue;
        }
    }

    private boolean isDeadCode(CodeUnit cu) {
        if (!(cu instanceof Instruction)) {
            return false;
        }
        if (this.isFalledTo(cu)) {
            return false;
        }
        if (this.hasReferencesTo(cu)) {
            return false;
        }
        return !((Instruction)cu).isInDelaySlot();
    }

    private boolean isFalledTo(CodeUnit cu) {
        CodeUnit prev = this.getPreviousCodeUnit(cu);
        return prev instanceof Instruction && ((Instruction)prev).hasFallthrough();
    }

    private CodeUnit getPreviousCodeUnit(CodeUnit cu) {
        try {
            Address prevAddr = cu.getMinAddress().subtractNoWrap(1L);
            return cu.getProgram().getListing().getCodeUnitContaining(prevAddr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isTransitionCode(CodeUnit cu) {
        CodeUnit previous = this.getPreviousCodeUnit(cu);
        if (cu instanceof Instruction) {
            return !(previous instanceof Instruction);
        }
        return !(previous instanceof Data);
    }

    private boolean hasReferencesTo(CodeUnit cu) {
        return cu.getProgram().getReferenceManager().hasReferencesTo(cu.getMinAddress());
    }

    private void init(Options options) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (int i = 0; i < 19; ++i) {
            sb.append("|");
        }
        HelpLocation help = new HelpLocation("CodeBrowserPlugin", "Format_Code");
        options.getOptions(GROUP_TITLE).setOptionsHelpLocation(help);
        options.registerOption(ENABLE_WORD_WRAP_MSG, (Object)false, null, "Enables word wrapping in the pre-comments field.  If word wrapping is on, user enter new lines are ignored and the entire comment is displayed in paragraph form.  If word wrapping is off, comments are displayed in line format however the user entered them.  Lines that are too long for the field, are truncated.");
        options.registerOption(SHOW_SUBROUTINE_PLATES_OPTION, (Object)true, help, "Toggle for whether a plate comment should be displayed for subroutines.");
        options.registerOption(SHOW_FUNCTION_PLATES_OPTION, (Object)true, help, "Toggle for whether a plate comment should be displayed for functions.");
        options.registerOption(SHOW_TRANSITION_PLATES_OPTION, (Object)false, help, "Toggle for whether a plate comment should be displayed for a change in the flow type between instructions, when data follows an instruction, an instruction follows data, or dead code is detected.");
        options.registerOption(SHOW_EXT_ENTRY_PLATES_OPTION, (Object)false, help, "Toggle for whether a plate comment should be displayed at an entry point.");
        options.registerOption(LINES_BEFORE_LABELS_OPTION, (Object)1, help, "Number of lines to displayed before a label.");
        options.registerOption(LINES_BEFORE_FUNCTIONS_OPTION, (Object)0, help, "Number of lines to displayed before the start of a function. This setting has precedence over Lines Before Plates.");
        options.registerOption(LINES_BEFORE_PLATES_OPTION, (Object)0, help, "Number of lines to displayed before a plate comment. This setting has precedence over Lines Before Labels.");
        help = new HelpLocation("CodeBrowserPlugin", "Function_Pointers");
        options.registerOption("Function Pointers.Display External Function Pointer Header", (Object)true, help, "Shows/hides function header format for pointers to external functions");
        options.registerOption("Function Pointers.Display Non-External Function Pointer Header", (Object)false, help, "Shows/hides function header format for pointers to non-external functions");
    }

    private class FieldElementResult {
        private FieldElement element;
        private boolean isClipped;

        FieldElementResult(FieldElement element, boolean isClipped) {
            this.element = element;
            this.isClipped = isClipped;
        }

        boolean isClipped() {
            return this.isClipped;
        }

        FieldElement getFieldElement() {
            return this.element;
        }
    }

    private class PlateFieldTextField
    extends VerticalLayoutTextField {
        private boolean isCommentClipped;
        private String commentText;

        public PlateFieldTextField(FieldElement[] textElements, PlateFieldFactory factory, ProxyObj<?> proxy, int startX, int width, String commentText, boolean isCommentClipped) {
            super(textElements, startX, width, Integer.MAX_VALUE, (HighlightFactory)new FieldHighlightFactory(PlateFieldFactory.this.hlProvider, factory.getClass(), proxy.getObject()));
            this.commentText = commentText;
            this.isCommentClipped = isCommentClipped;
        }

        public boolean isClipped() {
            return this.isCommentClipped;
        }

        public String getTextWithLineSeparators() {
            return this.commentText;
        }

        int getLeadingFillerLineCount() {
            int count = 0;
            for (Field field : this.subFields) {
                String text = field.getText().trim();
                ++count;
                if (text.isEmpty() || !text.startsWith("*")) continue;
                break;
            }
            return count;
        }
    }

    private class PlateListingTextField
    extends ListingTextField {
        protected PlateListingTextField(ProxyObj<?> proxy, PlateFieldTextField field) {
            super(PlateFieldFactory.this, proxy, (TextField)field);
        }

        PlateFieldTextField getPlateTextField() {
            return (PlateFieldTextField)this.field;
        }
    }
}

