/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.datatype.microsoft.RTTI0DataType;
import ghidra.app.util.datatype.microsoft.RTTI3DataType;
import ghidra.app.util.datatype.microsoft.RTTIDataType;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;

@Deprecated
public class RTTI1DataType
extends RTTIDataType {
    private static final long serialVersionUID = 1L;
    private static final int PMD_LENGTH = 12;
    private static final int M_DISP_OFFSET = 0;
    private static final int P_DISP_OFFSET = 4;
    private static final int V_DISP_OFFSET = 8;
    private static final int LENGTH = 28;
    private static final int RTTI_0_OFFSET = 0;
    private static final int NUM_CONTAINED_BASES_OFFSET = 4;
    private static final int PMD_OFFSET = 8;
    private static final int ATTRIBUTES_OFFSET = 20;
    private static final int RTTI_3_OFFSET = 24;
    private RTTI0DataType rtti0;
    private RTTI3DataType rtti3;

    public RTTI1DataType() {
        this(null);
    }

    public RTTI1DataType(DataTypeManager dtm) {
        super("RTTI_1", dtm);
        this.rtti0 = new RTTI0DataType(dtm);
        this.rtti3 = new RTTI3DataType(dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new RTTI1DataType(dtm);
    }

    public String getDescription() {
        return "RTTI 1 (RTTI Base Class Descriptor) Structure";
    }

    public String getMnemonic(Settings settings) {
        return "RTTI_1";
    }

    public int getLength() {
        return 28;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        Program program = buf.getMemory().getProgram();
        DataTypeManager dtm = program.getDataTypeManager();
        RTTI0DataType rtti0Dt = new RTTI0DataType(dtm);
        DataType rtti0RefDt = MSDataTypeUtils.getReferenceDataType(program, (DataType)rtti0Dt);
        RTTI3DataType rtti3Dt = new RTTI3DataType(dtm);
        DataType rtti3RefDt = MSDataTypeUtils.getReferenceDataType(program, (DataType)rtti3Dt);
        DataTypeComponent[] comps = new DataTypeComponent[5];
        comps[0] = new ReadOnlyDataTypeComponent(rtti0RefDt, (DynamicDataType)this, 4, 0, 0, "pTypeDescriptor", MSDataTypeUtils.is64Bit(program) ? "rtti0Displacement" : "rtti0Pointer");
        comps[1] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 1, 4, "numContainedBases", "number of direct bases of this base class");
        Structure pmdDataType = MSDataTypeUtils.getPMDDataType(program);
        comps[2] = new ReadOnlyDataTypeComponent((DataType)pmdDataType, (DynamicDataType)this, 12, 2, 8, "where", "");
        comps[3] = new ReadOnlyDataTypeComponent((DataType)new DWordDataType(), (DynamicDataType)this, 4, 3, 20, "attributes", null);
        comps[4] = new ReadOnlyDataTypeComponent(rtti3RefDt, (DynamicDataType)this, 4, 4, 24, "pClassHierarchyDescriptor", MSDataTypeUtils.is64Bit(program) ? "rtti3Displacement" : "rtti3Pointer");
        return comps;
    }

    public int getLength(Memory memory, Address address, byte[] bytes) {
        Program program = memory.getProgram();
        if (address.getOffset() % 4L != 0L) {
            return 0;
        }
        if (bytes.length < 28) {
            return 0;
        }
        Address pointedToAddress = MSDataTypeUtils.getReferencedAddress(program, address);
        if (pointedToAddress == null || !memory.contains(pointedToAddress)) {
            return 0;
        }
        return 28;
    }

    public Address getRtti0Address(Memory memory, Address rtti1Address) {
        return this.getRtti0Address(memory.getProgram(), rtti1Address);
    }

    public Address getRtti0Address(Program program, Address rtti1Address) {
        Address rtti0ComponentAddress = rtti1Address.add(0L);
        return MSDataTypeUtils.getReferencedAddress(program, rtti0ComponentAddress);
    }

    @Override
    public boolean isValid(Program program, Address startAddress, DataValidationOptions validationOptions) {
        Memory memory = program.getMemory();
        Listing listing = program.getListing();
        if (!memory.contains(startAddress)) {
            return false;
        }
        Address endAddress = startAddress.add(27L);
        try {
            MSDataTypeUtils.getBytes(memory, startAddress, 28);
        }
        catch (InvalidDataTypeException e) {
            return false;
        }
        if (!validationOptions.shouldIgnoreInstructions() && this.containsInstruction(listing, startAddress, endAddress)) {
            return false;
        }
        if (!validationOptions.shouldIgnoreDefinedData() && this.containsDefinedData(listing, startAddress, endAddress)) {
            return false;
        }
        if (startAddress.getOffset() % 4L != 0L) {
            return false;
        }
        return this.validateComponents(program, startAddress, validationOptions);
    }

    private boolean validateComponents(Program program, Address startAddress, DataValidationOptions validationOptions) {
        boolean validateReferredToData = validationOptions.shouldValidateReferredToData();
        Memory memory = program.getMemory();
        Address rtti0Address = MSDataTypeUtils.getReferencedAddress(program, startAddress);
        if (rtti0Address == null || validateReferredToData && !this.rtti0.isValid(program, rtti0Address, validationOptions)) {
            return false;
        }
        try {
            int numBases = memory.getInt(startAddress.add(4L));
            if (numBases < 0) {
                return false;
            }
            int mDisp = memory.getInt(startAddress.add(8L));
            if (mDisp < 0) {
                return false;
            }
            int pDisp = memory.getInt(startAddress.add(12L));
            if (pDisp < -1) {
                return false;
            }
            int vDisp = memory.getInt(startAddress.add(16L));
            if (vDisp < 0) {
                return false;
            }
        }
        catch (MemoryAccessException e) {
            return false;
        }
        catch (AddressOutOfBoundsException e) {
            return false;
        }
        Address rtti3Address = MSDataTypeUtils.getReferencedAddress(program, startAddress.add(24L));
        DataValidationOptions dontFollowOptions = new DataValidationOptions(validationOptions);
        dontFollowOptions.setValidateReferredToData(false);
        return rtti3Address != null && (!validateReferredToData || this.rtti3.isValid(program, rtti3Address, dontFollowOptions));
    }

    public String getDefaultLabelPrefix() {
        return "RTTI_1";
    }
}

