/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.debug.DebugDirectory;
import ghidra.app.util.bin.format.pe.debug.DebugFixupElement;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;

public class DebugFixup {
    private DebugFixupElement[] elements;

    static DebugFixup createDebugFixup(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        DebugFixup debugFixup = (DebugFixup)reader.getFactory().create(DebugFixup.class, new Object[0]);
        debugFixup.initDebugFixup(reader, debugDir, validator);
        return debugFixup;
    }

    private void initDebugFixup(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        int ptr = debugDir.getPointerToRawData();
        if (!validator.checkPointer(ptr)) {
            Msg.error((Object)this, (Object)("Invalid pointer " + Long.toHexString(ptr)));
            return;
        }
        ArrayList<DebugFixupElement> list = new ArrayList<DebugFixupElement>();
        for (int size = debugDir.getSizeOfData(); size > 0; size -= 12) {
            list.add(DebugFixupElement.createDebugFixupElement(reader, ptr));
            ptr += 12;
        }
        this.elements = new DebugFixupElement[list.size()];
        list.toArray(this.elements);
    }

    public DebugFixupElement[] getDebugFixupElements() {
        return this.elements;
    }
}

