/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheAcceleratorDof;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheAcceleratorInitializer;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImageInfoExtra;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheRangeEntry;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldCacheAccelerateInfo
implements StructConverter {
    private int version;
    private int imageExtrasCount;
    private int imagesExtrasOffset;
    private int bottomUpListOffset;
    private int dylibTrieOffset;
    private int dylibTrieSize;
    private int initializersOffset;
    private int initializersCount;
    private int dofSectionsOffset;
    private int dofSectionsCount;
    private int reExportListOffset;
    private int reExportCount;
    private int depListOffset;
    private int depListCount;
    private int rangeTableOffset;
    private int rangeTableCount;
    private long dyldSectionAddr;
    private BinaryReader reader;
    private List<DyldCacheImageInfoExtra> imageInfoExtraList;
    private List<DyldCacheAcceleratorInitializer> acceleratorInitializerList;
    private List<DyldCacheAcceleratorDof> acceleratorDofList;
    private List<DyldCacheRangeEntry> rangeEntryList;

    public DyldCacheAccelerateInfo(BinaryReader reader) throws IOException {
        this.reader = reader;
        this.version = reader.readNextInt();
        this.imageExtrasCount = reader.readNextInt();
        this.imagesExtrasOffset = reader.readNextInt();
        this.bottomUpListOffset = reader.readNextInt();
        this.dylibTrieOffset = reader.readNextInt();
        this.dylibTrieSize = reader.readNextInt();
        this.initializersOffset = reader.readNextInt();
        this.initializersCount = reader.readNextInt();
        this.dofSectionsOffset = reader.readNextInt();
        this.dofSectionsCount = reader.readNextInt();
        this.reExportListOffset = reader.readNextInt();
        this.reExportCount = reader.readNextInt();
        this.depListOffset = reader.readNextInt();
        this.depListCount = reader.readNextInt();
        this.rangeTableOffset = reader.readNextInt();
        this.rangeTableCount = reader.readNextInt();
        this.dyldSectionAddr = reader.readNextLong();
        this.imageInfoExtraList = new ArrayList<DyldCacheImageInfoExtra>(this.imageExtrasCount);
        this.acceleratorInitializerList = new ArrayList<DyldCacheAcceleratorInitializer>(this.initializersCount);
        this.acceleratorDofList = new ArrayList<DyldCacheAcceleratorDof>(this.dofSectionsCount);
        this.rangeEntryList = new ArrayList<DyldCacheRangeEntry>(this.rangeTableCount);
    }

    public void parse(Program program, Address accelerateInfoAddr, MessageLog log, TaskMonitor monitor) throws CancelledException {
        this.parseImageInfoExtra(program, accelerateInfoAddr, log, monitor);
        this.parseAcceleratorInitializer(program, accelerateInfoAddr, log, monitor);
        this.parseAcceleratorDof(program, accelerateInfoAddr, log, monitor);
        this.parseRangeEntry(program, accelerateInfoAddr, log, monitor);
    }

    public void markup(Program program, Address accelerateInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.markupImageInfoExtra(program, accelerateInfoAddr, monitor, log);
        this.markupAcceleratorInitializer(program, accelerateInfoAddr, monitor, log);
        this.markupAcceleratorDof(program, accelerateInfoAddr, monitor, log);
        this.markupReExportList(program, accelerateInfoAddr, monitor, log);
        this.markupDependencies(program, accelerateInfoAddr, monitor, log);
        this.markupRangeEntry(program, accelerateInfoAddr, monitor, log);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_accelerate_info", 0);
        struct.add(DWORD, "version", "currently 1");
        struct.add(DWORD, "imageExtrasCount", "does not include aliases");
        struct.add(DWORD, "imagesExtrasOffset", "offset into this chunk of first dyld_cache_image_info_extra");
        struct.add(DWORD, "bottomUpListOffset", "offset into this chunk to start of 16-bit array of sorted image indexes");
        struct.add(DWORD, "dylibTrieOffset", "offset into this chunk to start of trie containing all dylib paths");
        struct.add(DWORD, "dylibTrieSize", "size of trie containing all dylib paths");
        struct.add(DWORD, "initializersOffset", "offset into this chunk to start of initializers list");
        struct.add(DWORD, "initializersCount", "size of initializers list");
        struct.add(DWORD, "dofSectionsOffset", "offset into this chunk to start of DOF (DTrace object format) sections list");
        struct.add(DWORD, "dofSectionsCount", "size of DOF (DTrace object format sections list)");
        struct.add(DWORD, "reExportListOffset", "offset into this chunk to start of 16-bit array of re-exports");
        struct.add(DWORD, "reExportCount", "size of re-exports");
        struct.add(DWORD, "depListOffset", "offset into this chunk to start of 16-bit array of dependencies (0x8000 bit set if upward)");
        struct.add(DWORD, "depListCount", "size of dependencies");
        struct.add(DWORD, "rangeTableOffset", "offset into this chunk to start of ss");
        struct.add(DWORD, "rangeTableCount", "size of dependencies");
        struct.add(QWORD, "dyldSectionAddr", "address of libdyld's __dyld section in unslid cache");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    private void parseImageInfoExtra(Program program, Address accelerateInfoAddr, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD image image info extras...");
        monitor.initialize((long)this.imageExtrasCount);
        this.reader.setPointerIndex(this.imagesExtrasOffset);
        try {
            for (int i = 0; i < this.imageExtrasCount; ++i) {
                this.imageInfoExtraList.add(new DyldCacheImageInfoExtra(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to parse dyld_cache_image_info_extra.");
        }
    }

    private void parseAcceleratorInitializer(Program program, Address accelerateInfoAddr, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD accelerator initializers...");
        monitor.initialize((long)this.initializersCount);
        this.reader.setPointerIndex(this.initializersOffset);
        try {
            for (int i = 0; i < this.initializersCount; ++i) {
                this.acceleratorInitializerList.add(new DyldCacheAcceleratorInitializer(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to parse dyld_cache_accelerator_initializer.");
        }
    }

    private void parseAcceleratorDof(Program program, Address accelerateInfoAddr, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD DOF sections...");
        monitor.initialize((long)this.dofSectionsCount);
        this.reader.setPointerIndex(this.dofSectionsOffset);
        try {
            for (int i = 0; i < this.dofSectionsCount; ++i) {
                this.acceleratorDofList.add(new DyldCacheAcceleratorDof(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to parse dyld_cache_accelerator_dof.");
        }
    }

    private void parseRangeEntry(Program program, Address accelerateInfoAddr, MessageLog log, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Parsing DYLD range entries...");
        monitor.initialize((long)this.rangeTableCount);
        this.reader.setPointerIndex(this.rangeTableOffset);
        try {
            for (int i = 0; i < this.rangeTableCount; ++i) {
                this.rangeEntryList.add(new DyldCacheRangeEntry(this.reader));
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to parse dyld_cache_range_entry.");
        }
    }

    private void markupImageInfoExtra(Program program, Address accelerateInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD image info extras...");
        monitor.initialize((long)this.imageInfoExtraList.size());
        try {
            Address addr = accelerateInfoAddr.add((long)this.imagesExtrasOffset);
            for (DyldCacheImageInfoExtra imageInfoExtra : this.imageInfoExtraList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)imageInfoExtra.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup dyld_cache_image_info_extra.");
        }
    }

    private void markupAcceleratorInitializer(Program program, Address accelerateInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD accelerator initializers...");
        monitor.initialize((long)this.acceleratorInitializerList.size());
        try {
            Address addr = accelerateInfoAddr.add((long)this.initializersOffset);
            for (DyldCacheAcceleratorInitializer initializer : this.acceleratorInitializerList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)initializer.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                Address funcAddr = program.getImageBase().add((long)initializer.getFunctionsOffset());
                try {
                    program.getFunctionManager().createFunction(null, funcAddr, (AddressSetView)new AddressSet(funcAddr), SourceType.ANALYSIS);
                }
                catch (OverlappingFunctionException | InvalidInputException throwable) {
                    // empty catch block
                }
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup dyld_cache_accelerator_initializer.");
        }
    }

    private void markupAcceleratorDof(Program program, Address accelerateInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD DOF sections...");
        monitor.initialize((long)this.acceleratorDofList.size());
        try {
            Address addr = accelerateInfoAddr.add((long)this.dofSectionsOffset);
            for (DyldCacheAcceleratorDof dof : this.acceleratorDofList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)dof.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup dyld_cache_accelerator_dof.");
        }
    }

    private void markupReExportList(Program program, Address accelerateInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD re-exports...");
        monitor.initialize(1L);
        try {
            Address addr = accelerateInfoAddr.add((long)this.reExportListOffset);
            ArrayDataType dt = new ArrayDataType(WORD, this.reExportCount, WORD.getLength());
            DataUtilities.createData((Program)program, (Address)addr, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            program.getListing().setComment(addr, 0, "re-exports");
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup reExportList.");
        }
    }

    private void markupDependencies(Program program, Address accelerateInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD dependencies...");
        monitor.initialize(1L);
        try {
            Address addr = accelerateInfoAddr.add((long)this.depListOffset);
            ArrayDataType dt = new ArrayDataType(WORD, this.depListCount, WORD.getLength());
            DataUtilities.createData((Program)program, (Address)addr, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            program.getListing().setComment(addr, 0, "dependencies");
            monitor.incrementProgress(1L);
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup dependences.");
        }
    }

    private void markupRangeEntry(Program program, Address accelerateInfoAddr, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Marking up DYLD range entries...");
        monitor.initialize((long)this.rangeEntryList.size());
        try {
            Address addr = accelerateInfoAddr.add((long)this.rangeTableOffset);
            for (DyldCacheRangeEntry rangeEntry : this.rangeEntryList) {
                Data d = DataUtilities.createData((Program)program, (Address)addr, (DataType)rangeEntry.toDataType(), (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                addr = addr.add((long)d.getLength());
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
        catch (CodeUnitInsertionException | DuplicateNameException | IOException e) {
            log.appendMsg(DyldCacheAccelerateInfo.class.getSimpleName(), "Failed to markup dyld_cache_range_entry.");
        }
    }
}

