/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DyldInfoCommand
extends LoadCommand {
    private int rebase_off;
    private int rebase_size;
    private int bind_off;
    private int bind_size;
    private int weak_bind_off;
    private int weak_bind_size;
    private int lazy_bind_off;
    private int lazy_bind_size;
    private int export_off;
    private int export_size;

    static DyldInfoCommand createDyldInfoCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        DyldInfoCommand command = (DyldInfoCommand)reader.getFactory().create(DyldInfoCommand.class, new Object[0]);
        command.initDyldInfoCommand(reader);
        return command;
    }

    private void initDyldInfoCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.initLoadCommand(reader);
        this.rebase_off = reader.readNextInt();
        this.rebase_size = reader.readNextInt();
        this.bind_off = reader.readNextInt();
        this.bind_size = reader.readNextInt();
        this.weak_bind_off = reader.readNextInt();
        this.weak_bind_size = reader.readNextInt();
        this.lazy_bind_off = reader.readNextInt();
        this.lazy_bind_size = reader.readNextInt();
        this.export_off = reader.readNextInt();
        this.export_size = reader.readNextInt();
    }

    @Override
    public String getCommandName() {
        return "dyld_info_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                Address start;
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
                if (this.rebase_size > 0) {
                    start = baseAddress.getNewAddress((long)this.rebase_off);
                    api.createFragment(parentModule, this.getCommandName() + "_REBASE", start, this.rebase_size);
                }
                if (this.bind_size > 0) {
                    start = baseAddress.getNewAddress((long)this.bind_off);
                    api.createFragment(parentModule, this.getCommandName() + "_BIND", start, this.bind_size);
                }
                if (this.weak_bind_size > 0) {
                    start = baseAddress.getNewAddress((long)this.weak_bind_off);
                    api.createFragment(parentModule, this.getCommandName() + "_WEAK_BIND", start, this.weak_bind_size);
                }
                if (this.lazy_bind_size > 0) {
                    start = baseAddress.getNewAddress((long)this.lazy_bind_off);
                    api.createFragment(parentModule, this.getCommandName() + "_LAZY_BIND", start, this.lazy_bind_size);
                }
                if (this.export_size > 0) {
                    start = baseAddress.getNewAddress((long)this.export_off);
                    api.createFragment(parentModule, this.getCommandName() + "_EXPORT", start, this.export_size);
                }
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "rebase_off", null);
        struct.add(DWORD, "rebase_size", null);
        struct.add(DWORD, "bind_off", null);
        struct.add(DWORD, "bind_size", null);
        struct.add(DWORD, "weak_bind_off", null);
        struct.add(DWORD, "weak_bind_size", null);
        struct.add(DWORD, "lazy_bind_off", null);
        struct.add(DWORD, "lazy_bind_size", null);
        struct.add(DWORD, "export_off", null);
        struct.add(DWORD, "export_size", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getRebaseOffset() {
        return this.rebase_off;
    }

    public int getRebaseSize() {
        return this.rebase_size;
    }

    public int getBindOffset() {
        return this.bind_off;
    }

    public int getBindSize() {
        return this.bind_size;
    }

    public int getWeakBindOffset() {
        return this.weak_bind_off;
    }

    public int getWeakBindSize() {
        return this.weak_bind_size;
    }

    public int getLazyBindOffset() {
        return this.lazy_bind_off;
    }

    public int getLazyBindSize() {
        return this.lazy_bind_size;
    }

    public int getExportOffset() {
        return this.export_off;
    }

    public int getExportSize() {
        return this.export_size;
    }
}

