/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.sections;

import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.sections.AbstractFrameSection;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.Cie;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.FrameDescriptionEntry;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EhFrameSection
extends AbstractFrameSection {
    public static final String EH_FRAME_BLOCK_NAME = ".eh_frame";

    public EhFrameSection(TaskMonitor monitor, Program program) {
        super(monitor, program);
    }

    @Override
    public Cie getCie(Address currAddress) throws MemoryAccessException, ExceptionHandlerFrameException {
        return this.getCieOrCreateIfMissing(currAddress, false);
    }

    public List<RegionDescriptor> analyze(int fdeTableCount) throws MemoryAccessException, AddressOutOfBoundsException, ExceptionHandlerFrameException {
        MemoryBlock memBlock = this.program.getMemory().getBlock(EH_FRAME_BLOCK_NAME);
        if (memBlock != null && !this.monitor.isCancelled()) {
            return Collections.unmodifiableList(this.analyzeSection(memBlock));
        }
        return new ArrayList<RegionDescriptor>();
    }

    private List<RegionDescriptor> analyzeSection(MemoryBlock curMemBlock) throws MemoryAccessException, AddressOutOfBoundsException, ExceptionHandlerFrameException {
        this.monitor.setMessage("Analyzing " + curMemBlock.getName() + " section");
        this.monitor.setShowProgressValue(true);
        this.monitor.setIndeterminate(false);
        long bytesInBlock = curMemBlock.getSize();
        this.monitor.initialize(bytesInBlock);
        Address startAddr = curMemBlock.getStart();
        ProgramLocation loc = new ProgramLocation(this.program, startAddr);
        Address curAddress = loc.getAddress();
        ArrayList<RegionDescriptor> regions = new ArrayList<RegionDescriptor>();
        while (curAddress != null && curAddress.compareTo((Object)curMemBlock.getEnd()) < 0) {
            this.monitor.setProgress(curAddress.subtract(startAddr));
            Cie cie = this.getCie(curAddress);
            if (cie.isEndOfFrame()) break;
            curAddress = cie.getNextAddress();
            while (curAddress != null && curAddress.compareTo((Object)curMemBlock.getEnd()) < 0) {
                this.monitor.setProgress(curAddress.subtract(startAddr));
                Address currFdeAddr = curAddress;
                try {
                    FrameDescriptionEntry fde = new FrameDescriptionEntry(this.monitor, this.program, this);
                    RegionDescriptor region = fde.create(curAddress);
                    if (fde.isEndOfFrame()) break;
                    if (region != null) {
                        regions.add(region);
                        this.createFdeComment(curAddress);
                        this.monitor.incrementProgress(1L);
                    }
                    curAddress = fde.getNextAddress();
                }
                catch (ExceptionHandlerFrameException efe) {
                    curAddress = currFdeAddr;
                    break;
                }
            }
            this.createAugmentationData(regions, cie);
        }
        return regions;
    }
}

