/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingTool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.actions.PopupActionProvider;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProviderListener;
import ghidra.app.plugin.core.functioncompare.MappedFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class FunctionComparisonProvider
extends ComponentProviderAdapter
implements PopupActionProvider {
    private static final String HELP_TOPIC = "FunctionComparison";
    private static final Icon ICON = ResourceManager.loadImage((String)"images/page_white_c.png");
    private FunctionComparisonPanel functionComparisonPanel;
    private FunctionComparisonProviderListener listener;

    public FunctionComparisonProvider(Plugin plugin, Function[] functions, FunctionComparisonProviderListener listener) {
        super(plugin.getTool(), "Function Comparison", plugin.getName());
        this.listener = listener;
        if (ICON != null) {
            this.setIcon(ICON);
        }
        this.functionComparisonPanel = new MultiFunctionComparisonPanel((ComponentProvider)this, this.tool, functions);
        this.initFunctionComparisonPanel();
    }

    public FunctionComparisonProvider(Plugin plugin, Function[] leftFunctions, Function[] rightFunctions, FunctionComparisonProviderListener listener) {
        super(plugin.getTool(), HELP_TOPIC, plugin.getName());
        this.listener = listener;
        if (ICON != null) {
            this.setIcon(ICON);
        }
        this.functionComparisonPanel = new MultiFunctionComparisonPanel((ComponentProvider)this, this.tool, leftFunctions, rightFunctions);
        this.initFunctionComparisonPanel();
    }

    public FunctionComparisonProvider(Plugin plugin, HashMap<Function, HashSet<Function>> functionMap, FunctionComparisonProviderListener listener) {
        super(plugin.getTool(), HELP_TOPIC, plugin.getName());
        this.listener = listener;
        if (ICON != null) {
            this.setIcon(ICON);
        }
        this.functionComparisonPanel = new MappedFunctionComparisonPanel((ComponentProvider)this, this.tool, functionMap);
        this.initFunctionComparisonPanel();
    }

    private void initFunctionComparisonPanel() {
        this.setTransient();
        this.setTabText(this.functionComparisonPanel);
        this.addSpecificCodeComparisonActions();
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.setHelpLocation(new HelpLocation(HELP_TOPIC, "Function Comparison"));
    }

    private void setTabText(FunctionComparisonPanel functionCompPanel) {
        Function leftFunction = functionCompPanel.getLeftFunction();
        Function rightFunction = functionCompPanel.getRightFunction();
        String tabText = leftFunction == null && rightFunction == null ? "No Functions Yet" : this.getTabText(leftFunction, rightFunction);
        this.setTabText(tabText);
    }

    private String getTabText(Function function1, Function function2) {
        return (function1 != null ? function1.getName() : "none") + " & " + (function2 != null ? function2.getName() : "none");
    }

    private void addSpecificCodeComparisonActions() {
        DockingAction[] actions;
        for (DockingAction dockingAction : actions = this.functionComparisonPanel.getCodeComparisonActions()) {
            this.addLocalAction((DockingActionIf)dockingAction);
        }
    }

    public FunctionComparisonPanel getComponent() {
        return this.functionComparisonPanel;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("FunctionComparisonProvider\n");
        buff.append("Name: ");
        buff.append(this.getName() + "\n");
        Function leftFunction = this.functionComparisonPanel.getLeftFunction();
        String leftName = leftFunction != null ? leftFunction.getName() : "No Function";
        buff.append("Function 1: " + leftName + "\n");
        Function rightFunction = this.functionComparisonPanel.getRightFunction();
        String rightName = rightFunction != null ? rightFunction.getName() : "No Function";
        buff.append("Function 2: " + rightName + "\n");
        buff.append("tool = " + this.tool + "\n");
        return buff.toString();
    }

    public ActionContext getActionContext(MouseEvent event) {
        CodeComparisonPanel<? extends FieldPanelCoordinator> currentComponent = this.functionComparisonPanel.getCurrentComponent();
        return currentComponent.getActionContext((ComponentProvider)this, event);
    }

    public void removeFromTool() {
        this.tool.removePopupActionProvider((PopupActionProvider)this);
        super.removeFromTool();
    }

    public void closeComponent() {
        super.closeComponent();
        if (this.listener != null) {
            this.listener.providerClosed(this);
        }
    }

    public void programClosed(Program program) {
        Function[] functions;
        for (Function function : functions = this.functionComparisonPanel.getFunctions()) {
            if (function == null || function.getProgram() != program) continue;
            this.closeComponent();
            return;
        }
    }

    public void programRestored(Program program) {
        CodeComparisonPanel<? extends FieldPanelCoordinator> comparePanel = this.functionComparisonPanel.getCurrentComponent();
        comparePanel.programRestored(program);
    }

    public List<DockingActionIf> getPopupActions(DockingTool tool, ActionContext context) {
        ListingCodeComparisonPanel dualListingPanel;
        if (context.getComponentProvider() == this && (dualListingPanel = this.functionComparisonPanel.getDualListingPanel()) != null) {
            ListingPanel leftPanel = dualListingPanel.getLeftPanel();
            return leftPanel.getHeaderActions(this.getName());
        }
        return new ArrayList<DockingActionIf>();
    }

    public void readConfigState(SaveState saveState) {
        this.functionComparisonPanel.readConfigState(this.getName(), saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.functionComparisonPanel.writeConfigState(this.getName(), saveState);
    }
}

