/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.editor;

import docking.ComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.editor.TextEditorComponentProvider;
import ghidra.app.services.TextEditorService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

@PluginInfo(status=PluginStatus.STABLE, packageName="Ghidra Core", category="Common", shortDescription="Generic Text Editor", description="Provides a service to opening and editing text files.", servicesProvided={TextEditorService.class})
public class TextEditorManagerPlugin
extends ProgramPlugin
implements TextEditorService {
    private List<TextEditorComponentProvider> editors = new ArrayList<TextEditorComponentProvider>();

    public TextEditorManagerPlugin(PluginTool tool) {
        super(tool, true, true, true);
    }

    @Override
    public void edit(String name, InputStream inputStream) {
        try {
            TextEditorComponentProvider provider = new TextEditorComponentProvider(this, name, inputStream);
            this.editors.add(provider);
            this.tool.showComponentProvider((ComponentProvider)provider, true);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Unable to edit " + name + " due to I/O error.", "Edit", 0);
        }
    }

    public List<TextEditorComponentProvider> getEditors() {
        return this.editors;
    }

    public boolean removeTextFile(TextEditorComponentProvider editor, String textFileName) {
        if (editor.isChanged()) {
            int result;
            JComponent parentComponent = editor.getComponent();
            if (this.tool.isVisible((ComponentProvider)editor)) {
                parentComponent = editor.getComponent();
            }
            if ((result = OptionDialog.showYesNoDialog((Component)parentComponent, (String)this.getName(), (String)("'" + textFileName + "' has been modified. Discard changes?"))) != 1) {
                return false;
            }
        }
        this.tool.removeComponentProvider((ComponentProvider)editor);
        this.editors.remove((Object)editor);
        return true;
    }
}

