/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.UsrException;

public class FavoritesAction
extends CompositeEditorTableAction {
    private static final String GROUP_NAME = "2_DATA_EDITOR_ACTION";
    private DataType dataType;

    public FavoritesAction(CompositeEditorProvider provider, DataType dt) {
        super(provider, dt.getDisplayName(), GROUP_NAME, new String[]{"Favorite", dt.getDisplayName()}, new String[]{"Favorite", dt.getDisplayName()}, null);
        this.dataType = dt;
        this.getPopupMenuData().setParentMenuGroup(GROUP_NAME);
        this.adjustEnablement();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.add(this.dataType);
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage());
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
    }

    @Override
    public String getHelpName() {
        return "Favorite";
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.model.isAddAllowed(this.dataType);
    }

    public boolean isAddToPopup(ActionContext context) {
        return super.isEnabledForContext(context);
    }
}

