/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.app.cmd.module.AbstractModularizationCmd;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GraphAlgorithms;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.graph.CodeBlockEdge;
import ghidra.program.model.block.graph.CodeBlockVertex;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.program.util.ProgramSelection;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ComplexityDepthModularizationCmd
extends AbstractModularizationCmd {
    public ComplexityDepthModularizationCmd(GroupPath path, String treeName, ProgramSelection selection, CodeBlockModel blockModel) {
        super("Complexity Depth", path, treeName, selection, blockModel);
    }

    @Override
    protected void applyModel() throws CancelledException {
        GDirectedGraph<CodeBlockVertex, CodeBlockEdge> callGraph = this.createCallGraph();
        Map complexityDepth = GraphAlgorithms.getComplexityDepth(callGraph);
        this.rebuildProgramTree(complexityDepth);
    }

    private void rebuildProgramTree(Map<CodeBlockVertex, Integer> levelMap) throws CancelledException {
        List<List<CodeBlockVertex>> partition = this.partitionVerticesByReverseLevel(levelMap);
        for (int i = 0; i < partition.size(); ++i) {
            List<CodeBlockVertex> list = partition.get(i);
            ProgramModule levelModule = this.createModule(this.destinationModule, "Level " + i);
            for (CodeBlockVertex v : list) {
                this.monitor.checkCanceled();
                this.makeFragment(this.program, levelModule, v);
            }
        }
    }

    private List<List<CodeBlockVertex>> partitionVerticesByReverseLevel(Map<CodeBlockVertex, Integer> levelMap) {
        ArrayList<List<CodeBlockVertex>> levelList = new ArrayList<List<CodeBlockVertex>>();
        int maxLevel = this.getMaxLevel(levelMap);
        for (int i = 0; i <= maxLevel; ++i) {
            levelList.add(new ArrayList());
        }
        for (CodeBlockVertex codeBlockVertex : levelMap.keySet()) {
            int reverseLevel = maxLevel - levelMap.get(codeBlockVertex);
            ((List)levelList.get(reverseLevel)).add(codeBlockVertex);
        }
        for (List list : levelList) {
            Collections.sort(list);
        }
        return levelList;
    }

    private int getMaxLevel(Map<CodeBlockVertex, Integer> levelMap) {
        int maxLevel = -1;
        for (Integer level : levelMap.values()) {
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        return maxLevel;
    }
}

