/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.FunctionTagManager;

public class ChangeFunctionTagCmd
implements Command {
    private final int field;
    private final String tagName;
    private final String newVal;
    private String errorMsg = "";
    public static final int TAG_NAME_CHANGED = 0;
    public static final int TAG_COMMENT_CHANGED = 1;

    public ChangeFunctionTagCmd(String tagName, String newVal, int field) {
        if (field != 0 && field != 1) {
            throw new IllegalArgumentException("Invalid field: " + field);
        }
        this.tagName = tagName;
        this.newVal = newVal;
        this.field = field;
    }

    public boolean applyTo(DomainObject obj) {
        ProgramDB program = (ProgramDB)obj;
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)program.getFunctionManager();
        FunctionTagManager functionTagManager = functionManagerDB.getFunctionTagManager();
        FunctionTag tag = functionTagManager.getFunctionTag(this.tagName);
        if (tag == null) {
            this.errorMsg = "Function Tag not found: " + this.tagName;
            return false;
        }
        if (this.field == 0) {
            tag.setName(this.newVal);
        } else {
            tag.setComment(this.newVal);
        }
        return true;
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }

    public String getName() {
        return "Change Function Tag";
    }
}

