/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;

public class BTHeaderRec {
    public static final byte kHFSCaseFolding = -49;
    public static final byte kHFSBinaryCompare = -68;
    private final byte[] treeDepth = new byte[2];
    private final byte[] rootNode = new byte[4];
    private final byte[] leafRecords = new byte[4];
    private final byte[] firstLeafNode = new byte[4];
    private final byte[] lastLeafNode = new byte[4];
    private final byte[] nodeSize = new byte[2];
    private final byte[] maxKeyLength = new byte[2];
    private final byte[] totalNodes = new byte[4];
    private final byte[] freeNodes = new byte[4];
    private final byte[] reserved1 = new byte[2];
    private final byte[] clumpSize = new byte[4];
    private final byte[] btreeType = new byte[1];
    private final byte[] keyCompareType = new byte[1];
    private final byte[] attributes = new byte[4];
    private final byte[] reserved3 = new byte[64];

    public BTHeaderRec(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.treeDepth, 0, 2);
        System.arraycopy(data, offset + 2, this.rootNode, 0, 4);
        System.arraycopy(data, offset + 6, this.leafRecords, 0, 4);
        System.arraycopy(data, offset + 10, this.firstLeafNode, 0, 4);
        System.arraycopy(data, offset + 14, this.lastLeafNode, 0, 4);
        System.arraycopy(data, offset + 18, this.nodeSize, 0, 2);
        System.arraycopy(data, offset + 20, this.maxKeyLength, 0, 2);
        System.arraycopy(data, offset + 22, this.totalNodes, 0, 4);
        System.arraycopy(data, offset + 26, this.freeNodes, 0, 4);
        System.arraycopy(data, offset + 30, this.reserved1, 0, 2);
        System.arraycopy(data, offset + 32, this.clumpSize, 0, 4);
        System.arraycopy(data, offset + 36, this.btreeType, 0, 1);
        System.arraycopy(data, offset + 37, this.keyCompareType, 0, 1);
        System.arraycopy(data, offset + 38, this.attributes, 0, 4);
        System.arraycopy(data, offset + 42, this.reserved3, 0, 64);
    }

    public short getTreeDepth() {
        return Util.readShortBE((byte[])this.treeDepth);
    }

    public int getRootNode() {
        return Util.readIntBE((byte[])this.rootNode);
    }

    public int getLeafRecords() {
        return Util.readIntBE((byte[])this.leafRecords);
    }

    public int getFirstLeafNode() {
        return Util.readIntBE((byte[])this.firstLeafNode);
    }

    public int getLastLeafNode() {
        return Util.readIntBE((byte[])this.lastLeafNode);
    }

    public short getNodeSize() {
        return Util.readShortBE((byte[])this.nodeSize);
    }

    public short getMaxKeyLength() {
        return Util.readShortBE((byte[])this.maxKeyLength);
    }

    public int getTotalNodes() {
        return Util.readIntBE((byte[])this.totalNodes);
    }

    public int getFreeNodes() {
        return Util.readIntBE((byte[])this.freeNodes);
    }

    public short getReserved1() {
        return Util.readShortBE((byte[])this.reserved1);
    }

    public int getClumpSize() {
        return Util.readIntBE((byte[])this.clumpSize);
    }

    public byte getBtreeType() {
        return Util.readByteBE((byte[])this.btreeType);
    }

    public byte getKeyCompareType() {
        return Util.readByteBE((byte[])this.keyCompareType);
    }

    public int getAttributes() {
        return Util.readIntBE((byte[])this.attributes);
    }

    public int[] getReserved3() {
        return Util.readIntArrayBE((byte[])this.reserved3);
    }

    public boolean isBTBadCloseSet() {
        return Util.getBit((long)this.getAttributes(), (int)0);
    }

    public boolean isBTBigKeysSet() {
        return Util.getBit((long)this.getAttributes(), (int)1);
    }

    public boolean isBTVariableIndexKeysSet() {
        return Util.getBit((long)this.getAttributes(), (int)2);
    }

    public static int length() {
        return 106;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " treeDepth: " + this.getTreeDepth());
        ps.println(prefix + " rootNode: " + this.getRootNode());
        ps.println(prefix + " leafRecords: " + this.getLeafRecords());
        ps.println(prefix + " firstLeafNode: " + this.getFirstLeafNode());
        ps.println(prefix + " lastLeafNode: " + this.getLastLeafNode());
        ps.println(prefix + " nodeSize: " + this.getNodeSize());
        ps.println(prefix + " maxKeyLength: " + this.getMaxKeyLength());
        ps.println(prefix + " totalNodes: " + this.getTotalNodes());
        ps.println(prefix + " freeNodes: " + this.getFreeNodes());
        ps.println(prefix + " reserved1: " + this.getReserved1());
        ps.println(prefix + " clumpSize: " + this.getClumpSize());
        ps.println(prefix + " btreeType: " + this.getBtreeType());
        ps.println(prefix + " keyCompareType: " + this.getKeyCompareType());
        ps.println(prefix + " attributes: " + this.getAttributes());
        ps.println(prefix + " reserved3: " + this.getReserved3());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BTHeaderRec:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[BTHeaderRec.length()];
        int offset = 0;
        System.arraycopy(this.treeDepth, 0, result, offset, this.treeDepth.length);
        System.arraycopy(this.rootNode, 0, result, offset += this.treeDepth.length, this.rootNode.length);
        System.arraycopy(this.leafRecords, 0, result, offset += this.rootNode.length, this.leafRecords.length);
        System.arraycopy(this.firstLeafNode, 0, result, offset += this.leafRecords.length, this.firstLeafNode.length);
        System.arraycopy(this.lastLeafNode, 0, result, offset += this.firstLeafNode.length, this.lastLeafNode.length);
        System.arraycopy(this.nodeSize, 0, result, offset += this.lastLeafNode.length, this.nodeSize.length);
        System.arraycopy(this.maxKeyLength, 0, result, offset += this.nodeSize.length, this.maxKeyLength.length);
        System.arraycopy(this.totalNodes, 0, result, offset += this.maxKeyLength.length, this.totalNodes.length);
        System.arraycopy(this.freeNodes, 0, result, offset += this.totalNodes.length, this.freeNodes.length);
        System.arraycopy(this.reserved1, 0, result, offset += this.freeNodes.length, this.reserved1.length);
        System.arraycopy(this.clumpSize, 0, result, offset += this.reserved1.length, this.clumpSize.length);
        System.arraycopy(this.btreeType, 0, result, offset += this.clumpSize.length, this.btreeType.length);
        System.arraycopy(this.keyCompareType, 0, result, offset += this.btreeType.length, this.keyCompareType.length);
        System.arraycopy(this.attributes, 0, result, offset += this.keyCompareType.length, this.attributes.length);
        System.arraycopy(this.reserved3, 0, result, offset += this.attributes.length, this.reserved3.length);
        offset += this.reserved3.length;
        return result;
    }
}

