/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OdexedInvokeInline;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction3rmi
extends Instruction
implements RegisterRangeInstruction,
OdexedInvokeInline {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private short startReg;
    private short inlineIndex;

    public Instruction3rmi(Opcode opcode, short regCount, int startReg, int inlineIndex) {
        super(opcode);
        if (regCount >= 256) {
            throw new RuntimeException("regCount must be less than 256");
        }
        if (regCount < 0) {
            throw new RuntimeException("regCount cannot be negative");
        }
        if (startReg >= 65536) {
            throw new RuntimeException("The beginning register of the range must be less than 65536");
        }
        if (startReg < 0) {
            throw new RuntimeException("The beginning register of the range cannot be negative");
        }
        if (inlineIndex >= 65536) {
            throw new RuntimeException("The method index must be less than 65536");
        }
        this.regCount = (byte)regCount;
        this.startReg = (short)startReg;
        this.inlineIndex = (short)inlineIndex;
    }

    private Instruction3rmi(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regCount = (byte)NumberUtils.decodeUnsignedByte(buffer[bufferIndex + 1]);
        this.inlineIndex = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 2);
        this.startReg = (short)NumberUtils.decodeUnsignedShort(buffer, bufferIndex + 4);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regCount);
        out.writeShort(this.inlineIndex);
        out.writeShort(this.startReg);
    }

    @Override
    public Format getFormat() {
        return Format.Format3rmi;
    }

    @Override
    public int getRegCount() {
        return (short)(this.regCount & 0xFF);
    }

    @Override
    public int getStartRegister() {
        return this.startReg & 0xFFFF;
    }

    @Override
    public int getInlineIndex() {
        return this.inlineIndex & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction3rmi(opcode, buffer, bufferIndex);
        }
    }
}

